/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.resourcemanagement.support.server.managers.context.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAuthorization {
    private static Logger logger = LoggerFactory.getLogger(ContextAuthorization.class);
    public static final String USERNAME = "USERNAME";
    public static final String DEFAULT_USERNAME = "luca.frosini";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String DEFAULT_SERVICE_NAME = "accounting-harvester";
    protected Map<String, String> contextToToken = new HashMap<String, String>();
    protected Map<String, String> tokenToContext = new HashMap<String, String>();

    public ContextAuthorization() throws Exception {
        this.retrieveContextsAndTokens();
    }

    public String generateTokenForContext(String context, Properties properties) throws Exception {
        if (properties == null) {
            properties = (Properties)AccountingDashboardHarvesterPlugin.getProperties().get();
        }
        logger.info("Going to generate Token for Context {}", (Object)context);
        UserInfo userInfo = new UserInfo(properties.getProperty(USERNAME, DEFAULT_USERNAME), new ArrayList());
        String userToken = Constants.authorizationService().generateUserToken(userInfo, context);
        SecurityTokenProvider.instance.set(userToken);
        String generatedToken = Constants.authorizationService().generateExternalServiceToken(properties.getProperty(SERVICE_NAME, DEFAULT_SERVICE_NAME));
        logger.trace("Token for Context {} is {}", (Object)context, (Object)generatedToken);
        return generatedToken;
    }

    protected void retrieveContextsAndTokens() throws Exception {
        String initialToken = SecurityTokenProvider.instance.get();
        try {
            Properties properties = (Properties)AccountingDashboardHarvesterPlugin.getProperties().get();
            LinkedHashMap map = ContextManager.readContexts();
            for (String scope : map.keySet()) {
                try {
                    String context = ((ScopeBean)map.get(scope)).toString();
                    String generatedToken = this.generateTokenForContext(context, properties);
                    this.contextToToken.put(context, generatedToken);
                    this.tokenToContext.put(generatedToken, context);
                }
                catch (Exception e) {
                    logger.error("Error while elaborating {}", (Object)scope, (Object)e);
                    throw e;
                }
                finally {
                    SecurityTokenProvider.instance.reset();
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            SecurityTokenProvider.instance.set(initialToken);
        }
    }

    public String getTokenForContext(String contextFullName) {
        return this.contextToToken.get(contextFullName);
    }

    public String getContextFromToken(String token) {
        return this.tokenToContext.get(token);
    }

    public SortedSet<String> getContexts() {
        return new TreeSet<String>(this.contextToToken.keySet());
    }
}

