/*
 * Decompiled with CFR 0.152.
 */
package lombok.delombok;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.tools.JavaFileObject;
import lombok.delombok.FormatPreferenceScanner;
import lombok.delombok.FormatPreferences;
import lombok.delombok.PrettyCommentsPrinter;
import lombok.javac.CommentInfo;

public class DelombokResult {
    private final java.util.List<CommentInfo> comments;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final boolean changed;
    private final FormatPreferences formatPreferences;

    public DelombokResult(java.util.List<CommentInfo> comments, JCTree.JCCompilationUnit compilationUnit, boolean changed, FormatPreferences formatPreferences) {
        this.comments = comments;
        this.compilationUnit = compilationUnit;
        this.changed = changed;
        this.formatPreferences = formatPreferences;
    }

    public void print(Writer out) throws IOException {
        CharSequence content;
        if (!this.changed && (content = this.getContent()) != null) {
            out.write(content.toString());
            return;
        }
        if (this.formatPreferences.generateDelombokComment()) {
            out.write("// Generated by delombok at ");
            out.write(String.valueOf(new Date()));
            out.write(System.getProperty("line.separator"));
        }
        List<CommentInfo> comments_ = this.comments instanceof List ? (List<CommentInfo>)this.comments : List.from(this.comments.toArray(new CommentInfo[0]));
        FormatPreferences preferences = new FormatPreferenceScanner().scan(this.formatPreferences, this.getContent());
        this.compilationUnit.accept(new PrettyCommentsPrinter(out, this.compilationUnit, comments_, preferences));
    }

    private CharSequence getContent() throws IOException {
        JavaFileObject sourceFile = this.compilationUnit.getSourceFile();
        if (sourceFile == null) {
            return null;
        }
        return sourceFile.getCharContent(true);
    }

    public boolean isChanged() {
        return this.changed;
    }
}

