/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.facet;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.facet.DateRangeFacet;
import com.couchbase.client.java.search.facet.NumericRangeFacet;
import com.couchbase.client.java.search.facet.TermFacet;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public abstract class SearchFacet {
    private final String field;
    private final int limit;

    protected SearchFacet(String field, int limit) {
        this.field = field;
        this.limit = limit;
    }

    public static TermFacet term(String field, int limit) {
        return new TermFacet(field, limit);
    }

    public static NumericRangeFacet numeric(String field, int limit) {
        return new NumericRangeFacet(field, limit);
    }

    public static DateRangeFacet date(String field, int limit) {
        return new DateRangeFacet(field, limit);
    }

    public void injectParams(JsonObject queryJson) {
        queryJson.put("size", this.limit);
        queryJson.put("field", this.field);
    }
}

