/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.event.system;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventType;
import com.couchbase.client.core.utils.Events;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigUpdatedEvent
implements CouchbaseEvent {
    private final Set<String> bucketNames;
    private final Set<String> clusterNodes;

    public ConfigUpdatedEvent(ClusterConfig clusterConfig) {
        this.bucketNames = clusterConfig.bucketConfigs().keySet();
        HashSet<String> nodes = new HashSet<String>();
        for (Map.Entry<String, BucketConfig> cfg : clusterConfig.bucketConfigs().entrySet()) {
            for (NodeInfo node : cfg.getValue().nodes()) {
                nodes.add(node.hostname());
            }
        }
        this.clusterNodes = nodes;
    }

    public Set<String> openBuckets() {
        return this.bucketNames;
    }

    @Deprecated
    public Set<InetAddress> clusterNodes() {
        HashSet<InetAddress> nodes = new HashSet<InetAddress>();
        for (String na : this.clusterNodes) {
            try {
                nodes.add(InetAddress.getByName(na));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return nodes;
    }

    public Set<String> clusterNodesAsStrings() {
        return this.clusterNodes;
    }

    @Override
    public EventType type() {
        return EventType.SYSTEM;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = Events.identityMap(this);
        result.put("openBuckets", this.openBuckets());
        result.put("clusterNodes", Collections.unmodifiableSet(this.clusterNodes));
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConfigUpdatedEvent{");
        sb.append("bucketNames=").append(this.bucketNames);
        sb.append(", clusterNodes=").append(this.clusterNodes);
        sb.append('}');
        return sb.toString();
    }
}

