/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket.api;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.kv.AppendRequest;
import com.couchbase.client.core.message.kv.AppendResponse;
import com.couchbase.client.core.message.kv.CounterRequest;
import com.couchbase.client.core.message.kv.CounterResponse;
import com.couchbase.client.core.message.kv.InsertRequest;
import com.couchbase.client.core.message.kv.InsertResponse;
import com.couchbase.client.core.message.kv.PrependRequest;
import com.couchbase.client.core.message.kv.PrependResponse;
import com.couchbase.client.core.message.kv.RemoveRequest;
import com.couchbase.client.core.message.kv.RemoveResponse;
import com.couchbase.client.core.message.kv.ReplaceRequest;
import com.couchbase.client.core.message.kv.ReplaceResponse;
import com.couchbase.client.core.message.kv.TouchRequest;
import com.couchbase.client.core.message.kv.TouchResponse;
import com.couchbase.client.core.message.kv.UnlockRequest;
import com.couchbase.client.core.message.kv.UnlockResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonLongDocument;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.TemporaryLockFailureException;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;

@InterfaceAudience.Private
@InterfaceStability.Uncommitted
public class Mutate {
    public static <D extends Document<?>> Observable<D> insert(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                Span requestSpan = null;
                if (env.operationTracingEnabled()) {
                    Tracer.SpanBuilder spanBuilder = env.tracer().buildSpan("insert");
                    if (parent != null) {
                        spanBuilder = spanBuilder.asChildOf(parent);
                    }
                    Scope scope = spanBuilder.startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = env.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final InsertRequest request = new InsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), bucket);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)env);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<InsertResponse>>(){

                    public Observable<InsertResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<InsertResponse, D>(){

                    public D call(InsertResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case TOO_BIG: {
                                throw Utils.addDetails(new RequestTooBigException(), response);
                            }
                            case EXISTS: {
                                throw Utils.addDetails(new DocumentAlreadyExistsException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> upsert(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                Span requestSpan = null;
                if (env.operationTracingEnabled()) {
                    Tracer.SpanBuilder spanBuilder = env.tracer().buildSpan("upsert");
                    if (parent != null) {
                        spanBuilder = spanBuilder.asChildOf(parent);
                    }
                    Scope scope = spanBuilder.startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = env.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final UpsertRequest request = new UpsertRequest(document.id(), (ByteBuf)encoded.value1(), document.expiry(), ((Integer)encoded.value2()).intValue(), bucket);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)env);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<UpsertResponse>>(){

                    public Observable<UpsertResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<UpsertResponse, D>(){

                    public D call(UpsertResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case TOO_BIG: {
                                throw Utils.addDetails(new RequestTooBigException(), response);
                            }
                            case EXISTS: 
                            case LOCKED: {
                                throw Utils.addDetails(new CASMismatchException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> replace(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                Span requestSpan = null;
                if (env.operationTracingEnabled()) {
                    Tracer.SpanBuilder spanBuilder = env.tracer().buildSpan("replace");
                    if (parent != null) {
                        spanBuilder = spanBuilder.asChildOf(parent);
                    }
                    Scope scope = spanBuilder.startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = env.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final ReplaceRequest request = new ReplaceRequest(document.id(), (ByteBuf)encoded.value1(), document.cas(), document.expiry(), ((Integer)encoded.value2()).intValue(), bucket);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)env);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<ReplaceResponse>>(){

                    public Observable<ReplaceResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<ReplaceResponse, D>(){

                    public D call(ReplaceResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), document.expiry(), document.content(), response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case TOO_BIG: {
                                throw Utils.addDetails(new RequestTooBigException(), response);
                            }
                            case NOT_EXISTS: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case EXISTS: 
                            case LOCKED: {
                                throw Utils.addDetails(new CASMismatchException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> remove(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                final RemoveRequest request = new RemoveRequest(document.id(), document.cas(), bucket);
                if (parent == null) {
                    Utils.addRequestSpan(env, (CouchbaseRequest)request, "remove");
                } else {
                    Utils.addRequestSpanWithParent(env, parent, (CouchbaseRequest)request, "remove");
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<RemoveResponse>>(){

                    public Observable<RemoveResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<RemoveResponse, D>(){

                    public D call(RemoveResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case NOT_EXISTS: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case EXISTS: 
                            case LOCKED: {
                                throw Utils.addDetails(new CASMismatchException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static Observable<Boolean> unlock(final String id, final long cas, final CouchbaseEnvironment env, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<Boolean>>(){

            public Observable<Boolean> call() {
                final UnlockRequest request = new UnlockRequest(id, cas, bucket);
                Utils.addRequestSpan(env, (CouchbaseRequest)request, "unlock");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<UnlockResponse>>(){

                    public Observable<UnlockResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<UnlockResponse, Boolean>(){

                    public Boolean call(UnlockResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return true;
                        }
                        switch (response.status()) {
                            case NOT_EXISTS: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case LOCKED: {
                                throw Utils.addDetails(new TemporaryLockFailureException(), response);
                            }
                            case SERVER_BUSY: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static Observable<Boolean> touch(final String id, final int expiry, final CouchbaseEnvironment env, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<Boolean>>(){

            public Observable<Boolean> call() {
                final TouchRequest request = new TouchRequest(id, expiry, bucket);
                Utils.addRequestSpan(env, (CouchbaseRequest)request, "touch");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<TouchResponse>>(){

                    public Observable<TouchResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<TouchResponse, Boolean>(){

                    public Boolean call(TouchResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            return true;
                        }
                        switch (response.status()) {
                            case NOT_EXISTS: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: 
                            case LOCKED: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static Observable<JsonLongDocument> counter(final String id, final long delta, final long initial, final int expiry, final CouchbaseEnvironment env, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<JsonLongDocument>>(){

            public Observable<JsonLongDocument> call() {
                final CounterRequest request = new CounterRequest(id, initial, delta, expiry, bucket);
                if (parent == null) {
                    Utils.addRequestSpan(env, (CouchbaseRequest)request, "counter");
                } else {
                    Utils.addRequestSpanWithParent(env, parent, (CouchbaseRequest)request, "counter");
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<CounterResponse>>(){

                    public Observable<CounterResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<CounterResponse, JsonLongDocument>(){

                    public JsonLongDocument call(CounterResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (env.operationTracingEnabled()) {
                            env.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            int returnedExpiry = expiry == -1 ? 0 : expiry;
                            return JsonLongDocument.create(id, returnedExpiry, response.value(), response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case NOT_EXISTS: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: 
                            case LOCKED: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> append(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                Span requestSpan = null;
                if (env.operationTracingEnabled()) {
                    Tracer.SpanBuilder spanBuilder = env.tracer().buildSpan("append");
                    if (parent != null) {
                        spanBuilder = spanBuilder.asChildOf(parent);
                    }
                    Scope scope = spanBuilder.startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = env.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final AppendRequest request = new AppendRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), bucket);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)env);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<AppendResponse>>(){

                    public Observable<AppendResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<AppendResponse, D>(){

                    public D call(AppendResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case TOO_BIG: {
                                throw Utils.addDetails(new RequestTooBigException(), response);
                            }
                            case NOT_STORED: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: 
                            case LOCKED: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                            case EXISTS: {
                                throw Utils.addDetails(new CASMismatchException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }

    public static <D extends Document<?>> Observable<D> prepend(final D document, final CouchbaseEnvironment env, final Transcoder<Document<Object>, Object> transcoder, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit, final Span parent) {
        return Observable.defer((Func0)new Func0<Observable<D>>(){

            public Observable<D> call() {
                Span requestSpan = null;
                if (env.operationTracingEnabled()) {
                    Tracer.SpanBuilder spanBuilder = env.tracer().buildSpan("prepend");
                    if (parent != null) {
                        spanBuilder = spanBuilder.asChildOf(parent);
                    }
                    Scope scope = spanBuilder.startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = env.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                Tuple2<ByteBuf, Integer> encoded = transcoder.encode(document);
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final PrependRequest request = new PrependRequest(document.id(), document.cas(), (ByteBuf)encoded.value1(), bucket);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)env);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<PrependResponse>>(){

                    public Observable<PrependResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send((CouchbaseRequest)request);
                    }
                }).map(new Func1<PrependResponse, D>(){

                    public D call(PrependResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (response.status().isSuccess()) {
                            return transcoder.newDocument(document.id(), 0, null, response.cas(), response.mutationToken());
                        }
                        switch (response.status()) {
                            case TOO_BIG: {
                                throw Utils.addDetails(new RequestTooBigException(), response);
                            }
                            case NOT_STORED: {
                                throw Utils.addDetails(new DocumentDoesNotExistException(), response);
                            }
                            case TEMPORARY_FAILURE: 
                            case SERVER_BUSY: 
                            case LOCKED: {
                                throw Utils.addDetails(new TemporaryFailureException(), response);
                            }
                            case OUT_OF_MEMORY: {
                                throw Utils.addDetails(new CouchbaseOutOfMemoryException(), response);
                            }
                            case EXISTS: {
                                throw Utils.addDetails(new CASMismatchException(), response);
                            }
                        }
                        throw Utils.addDetails(new CouchbaseException(response.status().toString()), response);
                    }
                }), (CouchbaseRequest)request, env, timeout, timeUnit);
            }
        });
    }
}

