/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.harvester.sobigdata;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang.Validate;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.accounting.accounting.summary.access.model.update.AccountingRecord;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.dataharvest.AccountingDataHarvesterPlugin;
import org.gcube.dataharvest.datamodel.HarvestedDataKey;
import org.gcube.dataharvest.harvester.sobigdata.SoBigDataHarvester;
import org.gcube.dataharvest.utils.DateUtils;
import org.gcube.dataharvest.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMethodDownloadHarvester
extends SoBigDataHarvester {
    private static Logger logger = LoggerFactory.getLogger(DataMethodDownloadHarvester.class);
    private int count = 0;

    public DataMethodDownloadHarvester(Date start, Date end, SortedSet<String> contexts) throws Exception {
        super(start, end, contexts);
    }

    @Override
    public List<AccountingRecord> getAccountingRecords() throws Exception {
        String defaultContext = Utils.getCurrentContext();
        logger.debug("The context is {}", (Object)defaultContext);
        String vreName = DataMethodDownloadHarvester.getVRENameToHL(defaultContext);
        logger.debug("Getting VRE Name to HL from context/scope returns {} ", (Object)vreName);
        String user = vreName + "-Manager";
        logger.debug("Using user '{}' to getHome from HL", (Object)user);
        HomeManager manager = HomeLibrary.getHomeManagerFactory().getHomeManager();
        Home home = manager.getHome(user);
        JCRWorkspace ws = (JCRWorkspace)home.getWorkspace();
        String path = "/Workspace/MySpecialFolders/" + vreName;
        logger.debug("Getting item by Path {}", (Object)path);
        JCRWorkspaceItem item = (JCRWorkspaceItem)ws.getItemByPath(path);
        logger.debug("Analyzing {} in the period [{} to {}] starting from root {}", new Object[]{defaultContext, DateUtils.format(this.start), DateUtils.format(this.end), item.getName()});
        ScopeDescriptor defaultScopeDescriptor = AccountingDataHarvesterPlugin.getScopeDescriptor();
        AccountingRecord defaultHarvesteData = new AccountingRecord(defaultScopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.DATA_METHOD_DOWNLOAD), Long.valueOf(this.count));
        logger.debug("{} : {}", (Object)defaultHarvesteData.getDimension().getId(), (Object)defaultHarvesteData.getMeasure());
        ArrayList<AccountingRecord> accountingRecords = new ArrayList<AccountingRecord>();
        for (WorkspaceItem children : item.getChildren()) {
            this.count = 0;
            if (!children.isFolder()) continue;
            logger.debug("Getting statistics for folder {}", (Object)children.getName());
            this.getStats(children, this.start, this.end);
            String normalizedName = children.getName().replaceAll("[^A-Za-z0-9]", "");
            String context = (String)this.mapWsFolderNameToVRE.get(normalizedName);
            if (context != null && !context.isEmpty()) {
                logger.debug("Found context '{}' matching with normalized VRE name {} ", (Object)context, (Object)normalizedName);
                ScopeDescriptor scopeDescriptor = AccountingDataHarvesterPlugin.getScopeDescriptor(context);
                AccountingRecord ar = new AccountingRecord(scopeDescriptor, this.instant, this.getDimension(HarvestedDataKey.DATA_METHOD_DOWNLOAD), Long.valueOf(this.count));
                logger.debug("{} : {}", (Object)ar.getDimension().getId(), (Object)ar.getMeasure());
                accountingRecords.add(ar);
                continue;
            }
            logger.debug("No scope found matching the folder name {}, accounting its stats in the default context {}", (Object)normalizedName, (Object)defaultContext);
            defaultHarvesteData.setMeasure(Long.valueOf(defaultHarvesteData.getMeasure() + (long)this.count));
            logger.trace("Increased default context stats {}", (Object)defaultHarvesteData);
        }
        accountingRecords.add(defaultHarvesteData);
        logger.debug("In the period [from {} to {} ] returning workspace accouting data {}", new Object[]{DateUtils.format(this.start), DateUtils.format(this.end), accountingRecords});
        return accountingRecords;
    }

    private void getStats(WorkspaceItem baseItem, Date start, Date end) throws InternalErrorException {
        if (baseItem.isFolder()) {
            List children = baseItem.getChildren();
            for (WorkspaceItem child : children) {
                this.getStats(child, start, end);
            }
        } else {
            try {
                List accounting = baseItem.getAccounting();
                for (AccountingEntry entry : accounting) {
                    switch (entry.getEntryType()) {
                        case CREATE: 
                        case UPDATE: 
                        case READ: {
                            Calendar calendar = entry.getDate();
                            if (!calendar.after(DateUtils.dateToCalendar(start)) || !calendar.before(DateUtils.dateToCalendar(end))) break;
                            ++this.count;
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    private static String getVRENameToHL(String vre) {
        Validate.notNull((Object)vre, (String)"scope must be not null");
        String newName = vre.startsWith("/") ? vre.replace("/", "-").substring(1) : vre.replace("/", "-");
        return newName;
    }
}

