

package org.gcube.accounting.datamodel.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.gcube.accounting.exception.NotFoundException;
import org.gcube.accounting.exception.QueryFormatException;

public class QueryClause {

	private String key;
	private QueryOperator operator;
	private String value;
	
	public QueryClause(String clause) throws QueryFormatException {
		super();
		this.parseClause(clause);
	}
	
	public QueryClause(String key, QueryOperator operator, String value) {
		super();
		this.key = key;
		this.operator = operator;
		this.value = value;
	}

	public QueryClause(QueryField key, QueryOperator operator, String value) {
		this(key.toString(), operator, value);
	}

	private void parseClause(String clause) throws QueryFormatException {
		Pattern pattern = Pattern.compile("^\\s*([:a-zA-Z0-9_]+)\\s*(=|!=|<>|<=|>=|>|<)\\s*(.+)\\s*$");
		Matcher matcher = pattern.matcher(clause);
		if(matcher.matches()) {
			this.key = matcher.group(1).trim();
			try {
				this.operator = QueryOperator.getOperator(matcher.group(2));
			}
			catch(NotFoundException e) {
				throw new QueryFormatException(e.getMessage());
			}
			this.value = matcher.group(3).trim();
			//System.out.println("value = "+this.value);
		}
		else {
			throw new QueryFormatException("unable to parse query clause: " + clause);
		}
	}
	
	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}
	/**
	 * @return the operator
	 */
	public QueryOperator getOperator() {
		return operator;
	}
	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}
	
}
