

package org.gcube.accounting.webservice.configuration;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

/**
 * This class models Usage Tracker configuration. It relies on the configuration
 * location defined in the context file.
 */
public class PropertiesBaseConfiguration extends BaseConfiguration {

	/**
	 * A logger for this class
	 */
	protected static Logger logger = Logger.getLogger(PropertiesBaseConfiguration.class);
	
	/**
	 * The inner configuration (from commons-configuration)
	 */
	private static PropertiesConfiguration configuration;

	
	/**
	 * Private constructor
	 */
	protected PropertiesBaseConfiguration(String path) {
		try {
			logger.info("Loading configuration: " + path);

			// load the configuration
			configuration = new PropertiesConfiguration(path);

			// set the reloading strategy to enable hot-configuration
			FileChangedReloadingStrategy fcrs = new FileChangedReloadingStrategy();
			configuration.setReloadingStrategy(fcrs);
		}
		catch(ConfigurationException e) {
			e.printStackTrace();
		}
	}

	public String getString(String key) {
		return configuration.getString(key);
	}
	
	public Boolean getBoolean(String key) {
		return configuration.getBoolean(key);
	}

	public Boolean getBoolean(String key, Boolean def) {
		return configuration.getBoolean(key, def);
	}
	
	public Integer getInt(String key, Integer def) {
		return configuration.getInt(key, def);
	}

	public Integer getInt(String key) {
		return configuration.getInt(key);
	}
	
	public List<Object> getList(String key) {
		return configuration.getList(key);
	}

}
