

package org.gcube.accounting.datamodel.query;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import org.gcube.accounting.exception.QueryFormatException;

public class QueryHelper {

	//private static Logger logger = Logger.getLogger(QueryHelper.class);

	/**
	 * Parse a string of the form "k1=v1&k2=v2&k3=v3..." and produces a Map
	 * with the <key-value> pairs from the query
	 * @param query
	 * @return
	 */
	public static Map<String, QueryClause> parseQuery(String query) throws QueryFormatException {
		//logger.debug("Query = "+query);

		Map<String, QueryClause> out = new HashMap<String, QueryClause>();
		if(query==null)
			return out;
		StringTokenizer st = new StringTokenizer(query, "&");

		while(st.hasMoreTokens()) {
			String kv = st.nextToken();
			if(kv!=null)
				kv = kv.replaceAll("%%", "&");
			//System.out.println("kv = "+kv);
			// particular case for multiple values per field
			if(kv.contains(",")){
				StringTokenizer stMultipleValues = new StringTokenizer(kv, ",");
				while(stMultipleValues.hasMoreTokens()) {
					String kvMultipleValues = stMultipleValues.nextToken();
					//System.out.println(kvMultipleValues);
				}
			}
			QueryClause clause = new QueryClause(kv); 
			//System.out.println("QueryHelper.parseQuery = "+clause.getKey() + ", "+clause.getValue());
			out.put(clause.getKey(), clause);
		}
		return out;
	}

	public static Calendar getCalendar(Map<String, QueryClause> clauses, QueryField field) {
		return QueryHelper.getCalendar(clauses, field.toString());
	}

	public static Calendar getCalendar(Map<String, QueryClause> clauses, String field) {
		QueryClause qc = clauses.get(field);
		if (qc == null)
			return null;
		try {
			Long d = Long.parseLong(qc.getValue());
			Calendar out = Calendar.getInstance();
			out.setTimeInMillis(d);
			return out;
		} catch (NumberFormatException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String getString(Map<String, QueryClause> clauses, QueryField field) {
		QueryClause qc = clauses.get(field.toString());
		if (qc == null)
			return null;
		return qc.getValue();
	}


//	public static void main(String[] args) {
//		try {
//			Map<String,QueryClause> result = parseQuery("resourceScope=/vo1|/testing|/test");
//
//			Iterator iterator = result.keySet().iterator();  
//
//			while (iterator.hasNext()) {  
//				String key = iterator.next().toString();  
//	
//
//				System.out.println(key + " " + result.get(key).getKey() + "," + result.get(key).getValue());  
//			}  
//		} catch (QueryFormatException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}
}
