

package org.gcube.accounting.security.authn;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.log4j.Logger;

public class FileAuthenticationManager implements AuthenticationManager {

	/**
	 * A logger for this class
	 */
	private static Logger logger = Logger.getLogger(FileAuthenticationManager.class);
	 
	/**
	 * Back-end file used for authentication
	 */
	private PropertiesConfiguration file;
	
	private String realm;
	
	/**
	 * Basic constructor
	 * 
	 * @param file path
	 * @throws ConfigurationException 
	 */
	public FileAuthenticationManager(String file) throws ConfigurationException {
		this(new PropertiesConfiguration(file));
	}

	/**
	 * Basic constructor
	 * 
	 * @param propertiesConfiguration
	 */
	public FileAuthenticationManager(PropertiesConfiguration file) {
		this.file = file;
		FileChangedReloadingStrategy fcrs = new FileChangedReloadingStrategy();
		file.setReloadingStrategy(fcrs);
	}


	private String getUserPassword(String username){
		return file.getString(username);
	}
	
	public boolean authenticate(String username, String password) {
		String pwd = getUserPassword(username);
		if(pwd == null) {
			logger.info("unknown user " + username);
			return false;
		}
		if(!pwd.equals(password)) {
			logger.info("bad password provided for user " + username);
			return false;
		}
		logger.info("user " + username +" authenticated!");
		return true;
	}

	public String getRealm() {
		return realm;
	}

	public void setRealm(String realm) {
		this.realm = realm;
	}

}
