

package org.gcube.accounting.security.authz;

import org.apache.log4j.Logger;
import org.gcube.accounting.exception.NotFoundException;

public enum Action {
	
	READ_RECORD("readRecord", "can read usage records"),
	WRITE_RECORD("writeRecord", "can create new usage records"),
	UPDATE_RECORD("updateRecord", "can update an existing usage record"),
	DELETE_RECORD("deleteRecord", "can delete an existing usage record"),
	READ_BILL("readBill", "can read a bill"),
	ACT_AS_DELEGATE("actAsDelegate", "can act on behalf of someone else");

	private static Logger logger = Logger.getLogger(Action.class);

	private String name;
	private String description;

	private Action(String name, String description) {
		this.name = name;
		this.description = description;
	}

	public String toString() {
		return name + " (" + description + ")";
	}

	public static Action getAction(String s) throws NotFoundException {
		logger.debug(s);
		if (READ_RECORD.name.equals(s))
			return READ_RECORD;
		else if (WRITE_RECORD.name.equals(s))
			return WRITE_RECORD;
		else if (UPDATE_RECORD.name.equals(s))
			return UPDATE_RECORD;
		else if (DELETE_RECORD.name.equals(s))
			return DELETE_RECORD;
		else if (READ_BILL.name.equals(s))
			return READ_BILL;
		else if(ACT_AS_DELEGATE.name.equals(s))
			return ACT_AS_DELEGATE;
		throw new NotFoundException();
	}

}
