package org.gcube.accounting.datamodel.reports.aggregation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;


import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.accounting.datamodel.adapter.DateTimeAdapter;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.chrono.AssembledChronology.Fields;



@XmlRootElement
@XmlJavaTypeAdapter(type=DateTime.class, 
value=DateTimeAdapter.class)
public class AggregatedResult implements Serializable, Comparable<AggregatedResult> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String dimension;


	private DateTime time;
	private Metric metric;
	private double value;

	public AggregatedResult(){

	}

	public AggregatedResult(DateTime time, Metric metric, double value, String dimension) {
		this.time = time;
		this.metric = metric;
		this.value = value;
		this.dimension = dimension;
	}



	public Metric getMetric() {
		return metric;
	}

	public void setMetric(Metric metric) {
		this.metric = metric;
	}
	public double getValue() {
		return value;
	}
	public void setValue(double value) {
		this.value = value;
	}

	@XmlJavaTypeAdapter(type=DateTime.class, 
			value=DateTimeAdapter.class)
	public DateTime getTime() {
		return time;
	}

	public void setTime(DateTime time) {
		this.time = time;
	}




	public String getDimension() {
		return dimension;
	}

	public void setDimension(String dimension) {
		this.dimension = dimension;
	}
	
	@Override
	public int compareTo(AggregatedResult o) {
		return time.compareTo(o.getTime());
	}
	
	

	@Override
	public String toString() {
		return "AggregatedResult [dimension=" + dimension + ", time=" + time
				+ ", metric=" + metric + ", value=" + value + "]";
	}
	
	
	
}