/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.postgresql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.analytics.UsageValue;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceBackendQueryConfiguration;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.postgresql.Query;
import org.gcube.accounting.datamodel.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.utility.postgresql.RecordToDBConnection;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceQueryPostgreSQL
implements AccountingPersistenceBackendQuery {
    protected static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceQueryPostgreSQL.class);
    public static final String URL_PROPERTY_KEY = "URL";
    public static final int DEFAULT_TOP_LIMIT = 10;
    protected AccountingPersistenceBackendQueryConfiguration configuration;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected Class<? extends AggregatedRecord<?, ?>> clz;
    protected TemporalConstraint temporalConstraint;
    protected Set<String> contexts;
    protected Collection<Filter> filters;
    protected RecordToDBMapping recordToDBMapping = new RecordToDBMapping();

    public void prepareConnection(AccountingPersistenceBackendQueryConfiguration configuration) throws Exception {
        this.configuration = configuration;
        Map aggregatedRecords = RecordUtility.getAggregatedRecordClassesFound();
        for (String typeName : aggregatedRecords.keySet()) {
            try {
                Class clz = (Class)aggregatedRecords.get(typeName);
                this.recordToDBMapping.addRecordToDB(clz, (PersistenceBackendConfiguration)configuration);
            }
            catch (Exception e) {
                new RuntimeException(e);
            }
        }
    }

    protected Connection getConnection(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        RecordToDBConnection recordDBConnection = this.recordToDBMapping.getRecordDBInfo(clz);
        if (recordDBConnection == null) {
            this.recordToDBMapping.addRecordToDB(clz, (PersistenceBackendConfiguration)this.configuration);
            recordDBConnection = this.recordToDBMapping.getRecordDBInfo(clz);
        }
        return recordDBConnection.getConnection();
    }

    public void setRequestedRecords(Class<? extends AggregatedRecord<?, ?>> clz) {
        this.clz = clz;
    }

    public void setTemporalConstraint(TemporalConstraint temporalConstraint) {
        this.temporalConstraint = temporalConstraint;
    }

    public void setContexts(Set<String> contexts) {
        this.contexts = contexts;
    }

    public void setFilters(Collection<? extends Filter> filters) {
        this.filters = filters;
    }

    public RecordToDBMapping getRecordToDBMapping() {
        return this.recordToDBMapping;
    }

    protected void addProperty(ObjectNode objectNode, String key, Object value) {
        if (value instanceof Number) {
            if (value instanceof Integer) {
                objectNode.put(key, ((Integer)value).intValue());
                return;
            }
            Long longValue = Long.valueOf(value.toString());
            objectNode.put(key, longValue);
            return;
        }
        objectNode.put(key, value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SortedMap<Calendar, Info> getTimeSeries(Set<String> contexts) throws Exception {
        try (Connection connection = this.getConnection(this.clz);){
            Statement statement = connection.createStatement();
            TreeMap<Calendar, Info> result = new TreeMap<Calendar, Info>();
            Query query = new Query(this.clz);
            query.setTemporalConstraint(this.temporalConstraint);
            query.setFilters(this.filters);
            query.setContexts(contexts);
            String sql = query.getTimeSeriesQuery();
            Set<String> requestedTableField = query.getRequestedTableField();
            RecordToDBFields recordToDBMapper = query.getRecordToDBFields();
            logger.trace("Going to request the following query: {}", (Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String tableFieldName = recordToDBMapper.getTableField("startTime");
                OffsetDateTime offsetDateTime = resultSet.getObject(tableFieldName, OffsetDateTime.class);
                Calendar calendar = this.getCalendar(offsetDateTime);
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                for (String tableField : requestedTableField) {
                    String usageRecordField = recordToDBMapper.getRecordField(tableField);
                    Object obj = resultSet.getObject(tableField);
                    this.addProperty(objectNode, usageRecordField, obj);
                }
                Info info = new Info(calendar, (JsonNode)objectNode);
                result.put(calendar, info);
            }
            TreeMap<Calendar, Info> treeMap = result;
            return treeMap;
        }
    }

    public SortedMap<Calendar, Info> getTimeSeries() throws Exception {
        return this.getTimeSeries(this.contexts);
    }

    protected Calendar getCalendar(OffsetDateTime offsetDateTime) {
        Calendar calendar = Calendar.getInstance();
        long epochMillis = offsetDateTime.toInstant().toEpochMilli();
        calendar.setTimeInMillis(epochMillis);
        return calendar;
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getContextTimeSeries() throws Exception {
        TreeMap<Filter, SortedMap<Calendar, Info>> ret = new TreeMap<Filter, SortedMap<Calendar, Info>>();
        for (String context : this.contexts) {
            Filter contextFilter = new Filter("scope", context);
            HashSet<String> ctxs = new HashSet<String>();
            ctxs.add(context);
            SortedMap<Calendar, Info> timeSeries = this.getTimeSeries(ctxs);
            if (timeSeries.isEmpty()) continue;
            ret.put(contextFilter, timeSeries);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SortedSet<NumberedFilter> getNumberedValues(String key, String orderingProperty, Integer limit) throws Exception {
        try (Connection connection = this.getConnection(this.clz);){
            Statement statement = connection.createStatement();
            if (orderingProperty == null) {
                orderingProperty = AccountingPersistenceQuery.getDefaultOrderingProperties(this.clz);
            }
            if (limit != null && limit < 1) {
                limit = 10;
            }
            TreeSet<NumberedFilter> result = new TreeSet<NumberedFilter>();
            Query query = new Query(this.clz);
            query.setTemporalConstraint(this.temporalConstraint);
            query.setFilters(this.filters);
            query.setContexts(this.contexts);
            query.setTableFieldToRequest(key);
            query.setOrderByField(orderingProperty);
            query.setLimit(limit);
            String sql = query.getNextPossibleValueQuery();
            RecordToDBFields recordToDBFields = query.getRecordToDBFields();
            logger.trace("Going to request the following query: {}", (Object)sql);
            ResultSet resultSet = statement.executeQuery(sql);
            String tableFieldORderingProperty = recordToDBFields.getTableField(orderingProperty);
            while (resultSet.next()) {
                String tableFieldKey = recordToDBFields.getTableField(key);
                Object value = resultSet.getObject(tableFieldKey);
                Object numberObject = resultSet.getObject(tableFieldORderingProperty);
                NumberedFilter numberedFilter = new NumberedFilter(key, value.toString(), (Number)numberObject, orderingProperty);
                result.add(numberedFilter);
            }
            TreeSet<NumberedFilter> treeSet = result;
            return treeSet;
        }
    }

    public SortedSet<NumberedFilter> getFilterValues(String key) throws Exception {
        return this.getNumberedValues(key, null, null);
    }

    public SortedSet<NumberedFilter> getFilterValues(String key, Integer limit) throws Exception {
        return this.getNumberedValues(key, null, limit);
    }

    public SortedMap<NumberedFilter, SortedMap<Calendar, Info>> getTopValues(String topKey, String orderingProperty, Integer limit) throws Exception {
        TreeMap<NumberedFilter, SortedMap<Calendar, Info>> ret = new TreeMap<NumberedFilter, SortedMap<Calendar, Info>>();
        SortedSet<NumberedFilter> top = this.getNumberedValues(topKey, orderingProperty, limit);
        for (NumberedFilter numberedFilter : top) {
            this.filters.add((Filter)numberedFilter);
            SortedMap<Calendar, Info> map = this.getTimeSeries();
            ret.put(numberedFilter, map);
            this.filters.remove(numberedFilter);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record getRecord(String recordId, String type) throws Exception {
        Class aggregatedRecordClass = RecordUtility.getAggregatedRecordClass((String)type);
        try (Connection connection = this.getConnection(aggregatedRecordClass);){
            Statement statement = connection.createStatement();
            Query query = new Query(aggregatedRecordClass);
            query.setRecordId(recordId);
            String sql = query.getRecordQuery();
            RecordToDBFields recordToDBFields = query.getRecordToDBFields();
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            AggregatedRecord instance = (AggregatedRecord)aggregatedRecordClass.newInstance();
            Set requiredFields = instance.getRequiredFields();
            for (String recordField : requiredFields) {
                Object serializable;
                String tableField = recordToDBFields.getTableField(recordField);
                switch (recordField) {
                    case "startTime": 
                    case "endTime": 
                    case "creationTime": {
                        OffsetDateTime offsetDateTime = resultSet.getObject(tableField, OffsetDateTime.class);
                        Calendar calendar = this.getCalendar(offsetDateTime);
                        serializable = calendar.getTimeInMillis();
                        break;
                    }
                    default: {
                        serializable = resultSet.getObject(tableField).toString();
                    }
                }
                instance.setResourceProperty(recordField, (Serializable)serializable);
            }
            AggregatedRecord aggregatedRecord = instance;
            return aggregatedRecord;
        }
    }

    public SortedMap<Filter, SortedMap<Calendar, Info>> getSpaceTimeSeries(Set<String> dataTypes) throws Exception {
        return null;
    }

    public List<UsageValue> getUsageValueQuotaTotal(List<UsageValue> listUsage) throws Exception {
        return null;
    }

    public void close() throws Exception {
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }

    static {
        RecordUtility.addRecordPackage((Package)ServiceUsageRecord.class.getPackage());
        RecordUtility.addRecordPackage((Package)AggregatedServiceUsageRecord.class.getPackage());
    }
}

