/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.postgresql;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageStatusRecord;
import org.gcube.accounting.datamodel.aggregation.AggregatedStorageUsageRecord;
import org.gcube.accounting.utility.postgresql.PostgreSQLQuery;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.documentstore.records.AggregatedRecord;

public class Query
extends PostgreSQLQuery {
    public static final String DATE_OF_TIMESERIES_AS_FIELD = "startTime";
    public static final String NESTED_TABLE_NAME = "nested";
    private Class<? extends AggregatedRecord<?, ?>> clz;
    private final RecordToDBFields recordToDBFields;
    private Set<String> requestedTableField;
    protected TemporalConstraint temporalConstraint;
    protected Map<String, Collection<String>> filters;
    protected Set<String> contexts;
    private String tableFieldToRequest;
    private String orderByField;
    private Integer limit;
    private String recordId;

    public Query(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        this.clz = clz;
        this.recordToDBFields = RecordToDBMapping.getRecordToDBFields(clz);
    }

    public Set<String> getRequestedTableField() {
        return this.requestedTableField;
    }

    public void setTemporalConstraint(TemporalConstraint temporalConstraint) {
        this.temporalConstraint = temporalConstraint;
    }

    public void setFilters(Collection<? extends Filter> filters) {
        this.filters = new HashMap<String, Collection<String>>();
        if (filters != null && filters.size() > 0) {
            for (Filter filter : filters) {
                String key = filter.getKey();
                String value = filter.getValue();
                Collection<String> list = this.filters.get(key);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.filters.put(key, list);
                }
                list.add(value);
            }
        }
    }

    public void setContexts(Set<String> contexts) {
        this.contexts = contexts;
    }

    public void setTableFieldToRequest(String tableFieldToRequest) {
        this.tableFieldToRequest = tableFieldToRequest;
    }

    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void addContext(String context) {
        if (this.contexts == null) {
            this.contexts = new HashSet<String>();
        }
        this.contexts.add(context);
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public RecordToDBFields getRecordToDBMapper() {
        return this.recordToDBFields;
    }

    protected String getTableField(String fieldName) {
        return this.recordToDBFields.getTableField(fieldName);
    }

    protected void appendTableField(String fieldName) {
        this.stringBuffer.append(this.getTableField(fieldName));
    }

    public static String getFormattedDate(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        String date = simpleDateFormat.format(calendar.getTime());
        return date;
    }

    protected void addFilters() throws SQLException {
        if (this.filters != null && this.filters.size() > 0) {
            if (this.filters.size() > 1) {
                this.stringBuffer.append("(");
            }
            boolean first = true;
            for (String key : this.filters.keySet()) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuffer.append(" AND ");
                }
                this.addOrConditions(key, this.filters.get(key));
            }
            if (this.filters.size() > 1) {
                this.stringBuffer.append(")");
            }
        }
    }

    protected void addOrConditions(String key, Collection<String> values) throws SQLException {
        if (values != null && values.size() > 0) {
            if (values.size() > 1) {
                this.stringBuffer.append("(");
            }
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuffer.append(" OR ");
                }
                this.appendTableField(key);
                this.stringBuffer.append("=");
                this.appendValue((Serializable)((Object)value));
            }
            if (values.size() > 1) {
                this.stringBuffer.append(")");
            }
        }
    }

    protected void addContextFilter() throws SQLException {
        this.addOrConditions("scope", this.contexts);
    }

    protected void addEmittedFields(boolean addNested) throws Exception {
        Set aggregatedField = this.clz.newInstance().getAggregatedFields();
        block20: for (String fieldName : aggregatedField) {
            String dbField = this.getTableField(fieldName);
            switch (fieldName) {
                case "startTime": 
                case "endTime": 
                case "aggregated": {
                    continue block20;
                }
                case "operationCount": {
                    this.stringBuffer.append(", SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "dataCount": {
                    this.stringBuffer.append(", MAX(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "dataVolume": {
                    if (this.clz.isAssignableFrom(AggregatedStorageUsageRecord.class)) {
                        this.stringBuffer.append(", SUM(");
                    } else if (this.clz.isAssignableFrom(AggregatedStorageStatusRecord.class)) {
                        this.stringBuffer.append(", MAX(");
                    }
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "duration": {
                    this.stringBuffer.append(", ROUND(SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append("*");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.appendTableField("operationCount");
                    this.stringBuffer.append(")/SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.appendTableField("operationCount");
                    this.stringBuffer.append(")) AS ");
                    break;
                }
                case "maxInvocationTime": {
                    this.stringBuffer.append(", MAX(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "minInvocationTime": {
                    this.stringBuffer.append(", MIN(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                default: {
                    this.stringBuffer.append(", ");
                }
            }
            this.stringBuffer.append(dbField);
            this.requestedTableField.add(dbField);
        }
    }

    protected String getTimeBucketCalendarInterval(TemporalConstraint.AggregationMode aggregationMode) {
        TemporalConstraint.CalendarEnum calendarEnum = TemporalConstraint.CalendarEnum.values()[aggregationMode.ordinal()];
        return calendarEnum.name().toLowerCase();
    }

    private void newQuery() {
        this.stringBuffer = new StringBuffer();
        this.requestedTableField = new HashSet<String>();
        this.stringBuffer.append("SELECT ");
    }

    protected void addTemporalConstraintToQuery() throws SQLException {
        this.stringBuffer.append(" WHERE (");
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" > ");
        this.appendValue(this.temporalConstraint.getAlignedStartTime());
        this.stringBuffer.append(" AND ");
        tableField = this.getTableField("endTime");
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" < ");
        this.appendValue(this.temporalConstraint.getAlignedEndTime());
        this.stringBuffer.append(")");
    }

    protected void addDateGroupBy(boolean addNested) {
        this.stringBuffer.append(" GROUP BY ");
        if (addNested) {
            this.stringBuffer.append(NESTED_TABLE_NAME);
            this.stringBuffer.append(".");
        }
        this.appendTableField(DATE_OF_TIMESERIES_AS_FIELD);
    }

    protected void addDateOrderBy(boolean addNested) {
        this.stringBuffer.append(" ORDER BY ");
        if (addNested) {
            this.stringBuffer.append(NESTED_TABLE_NAME);
            this.stringBuffer.append(".");
        }
        this.appendTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(" ASC");
    }

    protected void addGroupAndOrderByForOrderByField() {
        this.stringBuffer.append(" GROUP BY ");
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" ORDER BY ");
        dbField = this.getTableField(this.orderByField);
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" DESC");
    }

    protected void addLimit() {
        if (this.limit != null) {
            this.stringBuffer.append(" LIMIT ");
            this.stringBuffer.append(this.limit.toString());
        }
    }

    protected void addRequestedField() {
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.stringBuffer.append(dbField);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append(", SUM(");
        dbField = this.getTableField(this.orderByField);
        this.stringBuffer.append(dbField);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append(") AS ");
        this.stringBuffer.append(dbField);
    }

    protected void addRequestedDate() {
        String calendarInterval = this.getTimeBucketCalendarInterval(this.temporalConstraint.getAggregationMode());
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append("date_trunc('");
        this.stringBuffer.append(calendarInterval);
        this.stringBuffer.append("', ");
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" AT TIME ZONE 'UTC') ");
        this.stringBuffer.append(tableField);
        this.requestedTableField.add(tableField);
    }

    public String getTimeSeriesQuery() throws Exception {
        this.newQuery();
        this.stringBuffer.append(NESTED_TABLE_NAME);
        this.stringBuffer.append(".");
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(tableField);
        this.addEmittedFields(true);
        this.stringBuffer.append(" FROM ( SELECT ");
        this.addRequestedDate();
        this.addEmittedFields(false);
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        this.addTemporalConstraintToQuery();
        if (this.filters != null && this.filters.size() > 0) {
            this.stringBuffer.append(" AND ");
            this.addFilters();
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            this.stringBuffer.append(" AND ");
            this.addContextFilter();
        }
        this.addDateGroupBy(false);
        this.addDateOrderBy(false);
        this.stringBuffer.append(") AS ");
        this.stringBuffer.append(NESTED_TABLE_NAME);
        this.addDateGroupBy(true);
        this.addDateOrderBy(true);
        return this.stringBuffer.toString();
    }

    public String getNextPossibleValueQuery() throws Exception {
        this.newQuery();
        this.addRequestedField();
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        boolean addAnd = false;
        if (this.temporalConstraint != null) {
            this.addTemporalConstraintToQuery();
            addAnd = true;
        }
        if (this.filters != null && this.filters.size() > 0) {
            if (addAnd) {
                this.stringBuffer.append(" AND ");
            }
            this.addFilters();
            addAnd = true;
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            if (addAnd) {
                this.stringBuffer.append(" AND ");
            }
            this.addContextFilter();
            addAnd = false;
        }
        this.addGroupAndOrderByForOrderByField();
        this.addLimit();
        return this.stringBuffer.toString();
    }

    public String getRecordQuery() {
        this.newQuery();
        this.stringBuffer.append("* ");
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        this.stringBuffer.append(" WHERE ");
        this.stringBuffer.append(" id=");
        this.appendString(this.recordId);
        return this.stringBuffer.toString();
    }

    public String getDinstinctValuesQuery() {
        this.newQuery();
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append("DISTINCT ");
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        return this.stringBuffer.toString();
    }
}

