/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.analytics.persistence.postgresql;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.accounting.utility.postgresql.PostgreSQLQuery;
import org.gcube.accounting.utility.postgresql.RecordToDBFields;
import org.gcube.accounting.utility.postgresql.RecordToDBMapping;
import org.gcube.documentstore.records.AggregatedRecord;

public class Query
extends PostgreSQLQuery {
    public static final String DATE_OF_TIMESERIES_AS_FIELD = "startTime";
    public static final String NESTED_TABLE_NAME = "nested";
    private Class<? extends AggregatedRecord<?, ?>> clz;
    private final RecordToDBFields recordToDBFields;
    private Set<String> requestedTableField;
    protected TemporalConstraint temporalConstraint;
    protected List<Filter> filters;
    protected Set<String> contexts;
    private String tableFieldToRequest;
    private String orderByField;
    private Integer limit;
    private String recordId;
    protected String orConditionKey;
    protected Set<String> orConditionValues;

    public void setOrConditionKey(String orConditionKey) {
        this.orConditionKey = orConditionKey;
    }

    public void setOrConditionValues(Collection<String> orConditionValues) {
        this.orConditionValues = new HashSet<String>(orConditionValues);
    }

    public void addOrConditionValue(String conditionValue) {
        if (this.orConditionValues == null) {
            this.orConditionValues = new HashSet<String>();
        }
        this.orConditionValues.add(conditionValue);
    }

    public Query(Class<? extends AggregatedRecord<?, ?>> clz) throws Exception {
        this.clz = clz;
        this.recordToDBFields = RecordToDBMapping.getRecordToDBFields(clz);
    }

    public Set<String> getRequestedTableField() {
        return this.requestedTableField;
    }

    public void setTemporalConstraint(TemporalConstraint temporalConstraint) {
        this.temporalConstraint = temporalConstraint;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setContexts(Set<String> contexts) {
        this.contexts = contexts;
    }

    public void setTableFieldToRequest(String tableFieldToRequest) {
        this.tableFieldToRequest = tableFieldToRequest;
    }

    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void addContext(String context) {
        if (this.contexts == null) {
            this.contexts = new HashSet<String>();
        }
        this.contexts.add(context);
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public RecordToDBFields getRecordToDBMapper() {
        return this.recordToDBFields;
    }

    protected String getTableField(String fieldName) {
        return this.recordToDBFields.getTableField(fieldName);
    }

    protected void appendTableField(String fieldName) {
        this.stringBuffer.append(this.getTableField(fieldName));
    }

    public static String getFormattedDate(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
        String date = simpleDateFormat.format(calendar.getTime());
        return date;
    }

    protected void addFilters() throws SQLException {
        if (this.filters != null && this.filters.size() > 0) {
            this.stringBuffer.append(" AND ");
            boolean first = true;
            for (Filter filter : this.filters) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuffer.append(" AND ");
                }
                this.appendTableField(filter.getKey());
                this.stringBuffer.append("=");
                this.appendValue((Serializable)((Object)filter.getValue()));
            }
        }
    }

    protected void addOrConditions(String key, Set<String> values) throws SQLException {
        if (values != null && values.size() > 0) {
            this.stringBuffer.append(" AND (");
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuffer.append(" OR ");
                }
                this.appendTableField(key);
                this.stringBuffer.append("=");
                this.appendValue((Serializable)((Object)value));
            }
            this.stringBuffer.append(")");
        }
    }

    protected void addContextFilter() throws SQLException {
        this.addOrConditions("scope", this.contexts);
    }

    protected void addOrConditionFilter() throws SQLException {
        this.addOrConditions(this.orConditionKey, this.orConditionValues);
    }

    protected void addEmittedFields(boolean addNested) throws Exception {
        Set aggregatedField = this.clz.newInstance().getAggregatedFields();
        block18: for (String fieldName : aggregatedField) {
            String dbField = this.getTableField(fieldName);
            switch (fieldName) {
                case "startTime": 
                case "endTime": 
                case "aggregated": {
                    continue block18;
                }
                case "operationCount": {
                    this.stringBuffer.append(", SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "dataVolume": {
                    this.stringBuffer.append(", SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "duration": {
                    this.stringBuffer.append(", ROUND(SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append("*");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.appendTableField("operationCount");
                    this.stringBuffer.append(")/SUM(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.appendTableField("operationCount");
                    this.stringBuffer.append(")) AS ");
                    break;
                }
                case "maxInvocationTime": {
                    this.stringBuffer.append(", MAX(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                case "minInvocationTime": {
                    this.stringBuffer.append(", MIN(");
                    if (addNested) {
                        this.stringBuffer.append(NESTED_TABLE_NAME);
                        this.stringBuffer.append(".");
                    }
                    this.stringBuffer.append(dbField);
                    this.stringBuffer.append(") AS ");
                    break;
                }
                default: {
                    this.stringBuffer.append(", ");
                }
            }
            this.stringBuffer.append(dbField);
            this.requestedTableField.add(dbField);
        }
    }

    protected String getTimeBucketCalendarInterval(TemporalConstraint.AggregationMode aggregationMode) {
        TemporalConstraint.CalendarEnum calendarEnum = TemporalConstraint.CalendarEnum.values()[aggregationMode.ordinal()];
        return calendarEnum.name().toLowerCase();
    }

    private void newQuery() {
        this.stringBuffer = new StringBuffer();
        this.requestedTableField = new HashSet<String>();
        this.stringBuffer.append("SELECT ");
    }

    protected void addTemporalConstraintToQuery() throws SQLException {
        this.stringBuffer.append(" WHERE ");
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" > ");
        this.appendValue(this.temporalConstraint.getAlignedStartTime());
        this.stringBuffer.append(" AND ");
        tableField = this.getTableField("endTime");
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" < ");
        this.appendValue(this.temporalConstraint.getAlignedEndTime());
    }

    protected void addDateGroupBy(boolean addNested) {
        this.stringBuffer.append(" GROUP BY ");
        if (addNested) {
            this.stringBuffer.append(NESTED_TABLE_NAME);
            this.stringBuffer.append(".");
        }
        this.appendTableField(DATE_OF_TIMESERIES_AS_FIELD);
    }

    protected void addDateOrderBy(boolean addNested) {
        this.stringBuffer.append(" ORDER BY ");
        if (addNested) {
            this.stringBuffer.append(NESTED_TABLE_NAME);
            this.stringBuffer.append(".");
        }
        this.appendTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(" ASC");
    }

    protected void addGroupAndOrderByForOrderByField() {
        this.stringBuffer.append(" GROUP BY ");
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" ORDER BY ");
        dbField = this.getTableField(this.orderByField);
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" DESC");
    }

    protected void addLimit() {
        this.stringBuffer.append(" LIMIT ");
        if (this.limit != null) {
            this.stringBuffer.append(this.limit.toString());
        } else {
            this.stringBuffer.append(50);
        }
    }

    protected void addRequestedField() {
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.stringBuffer.append(dbField);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append(", SUM(");
        dbField = this.getTableField(this.orderByField);
        this.stringBuffer.append(dbField);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append(") AS ");
        this.stringBuffer.append(dbField);
    }

    protected void addRequestedDate() {
        String calendarInterval = this.getTimeBucketCalendarInterval(this.temporalConstraint.getAggregationMode());
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append("date_trunc('");
        this.stringBuffer.append(calendarInterval);
        this.stringBuffer.append("', ");
        this.stringBuffer.append(tableField);
        this.stringBuffer.append(" AT TIME ZONE 'UTC') ");
        this.stringBuffer.append(tableField);
        this.requestedTableField.add(tableField);
    }

    public String getTimeSeriesQuery() throws Exception {
        this.newQuery();
        this.stringBuffer.append(NESTED_TABLE_NAME);
        this.stringBuffer.append(".");
        String tableField = this.getTableField(DATE_OF_TIMESERIES_AS_FIELD);
        this.stringBuffer.append(tableField);
        this.addEmittedFields(true);
        this.stringBuffer.append(" FROM ( SELECT ");
        this.addRequestedDate();
        this.addEmittedFields(false);
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        this.addTemporalConstraintToQuery();
        this.addFilters();
        this.addContextFilter();
        this.addDateGroupBy(false);
        this.addDateOrderBy(false);
        this.stringBuffer.append(") AS ");
        this.stringBuffer.append(NESTED_TABLE_NAME);
        this.addDateGroupBy(true);
        this.addDateOrderBy(true);
        return this.stringBuffer.toString();
    }

    public String getNextPossibleValueQuery() throws Exception {
        this.newQuery();
        this.addRequestedField();
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        this.addTemporalConstraintToQuery();
        this.addFilters();
        this.addContextFilter();
        this.addGroupAndOrderByForOrderByField();
        this.addLimit();
        return this.stringBuffer.toString();
    }

    public String getRecordQuery() {
        this.newQuery();
        this.stringBuffer.append("* ");
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        this.stringBuffer.append(" WHERE ");
        this.stringBuffer.append(" id=");
        this.appendString(this.recordId);
        return this.stringBuffer.toString();
    }

    public String getDinstinctValuesQuery() {
        this.newQuery();
        String dbField = this.getTableField(this.tableFieldToRequest);
        this.requestedTableField.add(dbField);
        this.stringBuffer.append("DISTINCT ");
        this.stringBuffer.append(dbField);
        this.stringBuffer.append(" FROM ");
        this.stringBuffer.append(this.recordToDBFields.getTableName());
        return this.stringBuffer.toString();
    }
}

