/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.ektorp.util.Exceptions;

public class URI {
    private final StringBuilder path;
    private final boolean prototype;
    private StringBuilder params;
    private String uri;

    private URI(String path) {
        this.path = new StringBuilder(path);
        this.prototype = false;
    }

    private URI(String path, boolean prototype) {
        this.path = new StringBuilder(path);
        this.prototype = prototype;
    }

    private URI(StringBuilder path, StringBuilder params) {
        this.path = path;
        this.params = params;
        this.prototype = false;
    }

    private URI(StringBuilder path) {
        this(path, null);
    }

    public static URI of(String path) {
        return new URI(path);
    }

    public static URI prototype(String path) {
        return new URI(path, true);
    }

    public URI copy() {
        return this.params != null ? new URI(new StringBuilder(this.path), new StringBuilder(this.params)) : new URI(new StringBuilder(this.path));
    }

    public URI append(String pathElement) {
        if (this.prototype) {
            return this.copy().append(pathElement);
        }
        if (this.path.charAt(this.path.length() - 1) != '/') {
            this.path.append("/");
        }
        try {
            if (!pathElement.startsWith("_")) {
                pathElement = URLEncoder.encode(pathElement, "UTF-8");
            }
            this.path.append(pathElement);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate(e);
        }
        this.uri = null;
        return this;
    }

    public URI param(String name, String value) {
        if (this.prototype) {
            return this.copy().param(name, value);
        }
        if (this.params != null) {
            this.params().append("&");
        } else {
            this.params().append("?");
        }
        try {
            this.params().append(name).append("=").append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.propagate(e);
        }
        this.uri = null;
        return this;
    }

    public URI param(String name, int value) {
        return this.param(name, Integer.toString(value));
    }

    public URI param(String name, long value) {
        return this.param(name, Long.toString(value));
    }

    private StringBuilder params() {
        if (this.params == null) {
            this.params = new StringBuilder();
        }
        return this.params;
    }

    public String toString() {
        if (this.uri == null) {
            this.uri = this.params != null ? this.path.append((CharSequence)this.params).toString() : this.path.toString();
        }
        return this.uri;
    }

    public void params(Map<String, String> params) {
        for (Map.Entry<String, String> e : params.entrySet()) {
            this.param(e.getKey(), e.getValue());
        }
    }
}

