/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.query;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.query.SearchQuery;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class DateRangeQuery
extends SearchQuery {
    private static final boolean INCLUSIVE_START = true;
    private static final boolean INCLUSIVE_END = false;
    private static final String DATE_TIME_PARSER = "dateTimeOptional";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final Date start;
    private final Date end;
    private final boolean inclusiveStart;
    private final boolean inclusiveEnd;
    private final String field;
    private final String dateTimeParser;

    protected DateRangeQuery(Builder builder) {
        super(builder);
        this.start = builder.start;
        this.end = builder.end;
        this.inclusiveStart = builder.inclusiveStart;
        this.inclusiveEnd = builder.inclusiveEnd;
        this.field = builder.field;
        this.dateTimeParser = builder.dateTimeParser;
    }

    public static Builder on(String index) {
        return new Builder(index);
    }

    public Date start() {
        return this.start;
    }

    public Date end() {
        return this.end;
    }

    public boolean inclusiveStart() {
        return this.inclusiveStart;
    }

    public boolean inclusiveEnd() {
        return this.inclusiveEnd;
    }

    public String field() {
        return this.field;
    }

    @Override
    public double boost() {
        return this.boost;
    }

    @Override
    public JsonObject queryJson() {
        return JsonObject.create().put("start", DATE_FORMAT.format(this.start)).put("end", DATE_FORMAT.format(this.end)).put("inclusiveStart", this.inclusiveStart).put("inclusiveEnd", this.inclusiveEnd).put("field", this.field).put("datetime_parser", this.dateTimeParser);
    }

    public static class Builder
    extends SearchQuery.Builder {
        public String dateTimeParser = "dateTimeOptional";
        private Date start;
        private Date end;
        private boolean inclusiveStart = true;
        private boolean inclusiveEnd = false;
        private String field;

        protected Builder(String index) {
            super(index);
        }

        @Override
        public DateRangeQuery build() {
            return new DateRangeQuery(this);
        }

        public Builder start(Date start) {
            this.start = start;
            return this;
        }

        public Builder end(Date end) {
            this.end = end;
            return this;
        }

        public Builder inclusiveStart(boolean inclusiveStart) {
            this.inclusiveStart = inclusiveStart;
            return this;
        }

        public Builder inclusiveEnd(boolean inclusiveEnd) {
            this.inclusiveEnd = inclusiveEnd;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder dateTimeParser(String dateTimeParser) {
            this.dateTimeParser = dateTimeParser;
            return this;
        }
    }
}

