/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.util.retry.Retry;
import com.couchbase.client.java.util.retry.RetryWhenFunction;
import com.couchbase.client.java.util.retry.RetryWithDelayHandler;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action4;
import rx.functions.Func1;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class RetryBuilder {
    private int maxAttempts = 1;
    private Delay delay = Retry.DEFAULT_DELAY;
    private List<Class<? extends Throwable>> errorsStoppingRetry = null;
    private Action4<Integer, Throwable, Long, TimeUnit> doOnRetryAction = null;
    private Func1<Throwable, Boolean> retryErrorPredicate = null;
    private boolean inverse = false;
    private Scheduler scheduler = null;

    private RetryBuilder() {
    }

    public static RetryBuilder anyOf(Class<? extends Throwable> ... types) {
        RetryBuilder retryBuilder = new RetryBuilder();
        retryBuilder.maxAttempts = 1;
        retryBuilder.errorsStoppingRetry = Arrays.asList(types);
        retryBuilder.inverse = true;
        return retryBuilder;
    }

    public static RetryBuilder allBut(Class<? extends Throwable> ... types) {
        RetryBuilder retryBuilder = new RetryBuilder();
        retryBuilder.maxAttempts = 1;
        retryBuilder.errorsStoppingRetry = Arrays.asList(types);
        retryBuilder.inverse = false;
        return retryBuilder;
    }

    public static RetryBuilder any() {
        RetryBuilder retryBuilder = new RetryBuilder();
        retryBuilder.maxAttempts = 1;
        return retryBuilder;
    }

    public static RetryBuilder anyMatches(Func1<Throwable, Boolean> retryErrorPredicate) {
        RetryBuilder retryBuilder = new RetryBuilder();
        retryBuilder.maxAttempts = 1;
        retryBuilder.retryErrorPredicate = retryErrorPredicate;
        return retryBuilder;
    }

    public RetryBuilder once() {
        this.maxAttempts = 1;
        return this;
    }

    public RetryBuilder max(int maxAttempts) {
        this.maxAttempts = Math.min(maxAttempts, 0x7FFFFFFE);
        return this;
    }

    public RetryBuilder delay(Delay delay) {
        return this.delay(delay, null);
    }

    public RetryBuilder delay(Scheduler scheduler) {
        return this.delay(null, scheduler);
    }

    public RetryBuilder delay(Delay delay, Scheduler scheduler) {
        this.delay = delay == null ? Retry.DEFAULT_DELAY : delay;
        this.scheduler = scheduler;
        return this;
    }

    public RetryBuilder doOnRetry(Action4<Integer, Throwable, Long, TimeUnit> doOnRetryAction) {
        this.doOnRetryAction = doOnRetryAction;
        return this;
    }

    public RetryWhenFunction build() {
        Func1<Throwable, Boolean> filter = (this.errorsStoppingRetry == null || this.errorsStoppingRetry.isEmpty()) && this.retryErrorPredicate == null ? null : (this.retryErrorPredicate != null ? new InversePredicate(this.retryErrorPredicate) : new ShouldStopOnError(this.errorsStoppingRetry, this.inverse));
        RetryWithDelayHandler handler = this.scheduler == null ? new RetryWithDelayHandler(this.maxAttempts, this.delay, filter, this.doOnRetryAction) : new RetryWithDelayHandler(this.maxAttempts, this.delay, filter, this.doOnRetryAction, this.scheduler);
        return new RetryWhenFunction(handler);
    }

    public static interface OnRetryAction
    extends Action4<Integer, Throwable, Long, TimeUnit> {
    }

    protected static class ShouldStopOnError
    implements Func1<Throwable, Boolean> {
        private final List<Class<? extends Throwable>> errorsStoppingRetry;
        private final boolean inverse;

        public ShouldStopOnError(List<Class<? extends Throwable>> filterErrorList, boolean inverse) {
            this.errorsStoppingRetry = filterErrorList;
            this.inverse = inverse;
        }

        @Override
        public Boolean call(Throwable o) {
            for (Class<? extends Throwable> aClass : this.errorsStoppingRetry) {
                if (!aClass.isInstance(o)) continue;
                return !this.inverse;
            }
            return this.inverse;
        }
    }

    protected static class InversePredicate
    implements Func1<Throwable, Boolean> {
        private final Func1<Throwable, Boolean> predicate;

        public InversePredicate(Func1<Throwable, Boolean> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Boolean call(Throwable throwable) {
            Boolean toInvert = this.predicate.call(throwable);
            if (toInvert == null) {
                return null;
            }
            if (Boolean.TRUE.equals(toInvert)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }
}

