/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.clause;

import com.couchbase.client.java.query.dsl.Expression;
import java.util.ArrayList;

public class UpdateForClause {
    private ArrayList<Expression> vars = new ArrayList();

    private UpdateForClause() {
    }

    public static UpdateForClause forIn(String variable, String path) {
        UpdateForClause clause = new UpdateForClause();
        return clause.in(variable, path);
    }

    public static UpdateForClause forWithin(String variable, String path) {
        UpdateForClause clause = new UpdateForClause();
        return clause.within(variable, path);
    }

    public UpdateForClause in(String variable, String path) {
        Expression in = Expression.x(variable + " IN " + path);
        this.vars.add(in);
        return this;
    }

    public UpdateForClause within(String variable, String path) {
        this.vars.add(Expression.x(variable + " WITHIN " + path));
        return this;
    }

    public Expression when(Expression condition) {
        StringBuilder updateFor = new StringBuilder("FOR ");
        for (Expression var : this.vars) {
            updateFor.append(var.toString()).append(", ");
        }
        updateFor.delete(updateFor.length() - 2, updateFor.length());
        if (condition != null) {
            updateFor.append(" WHEN ").append(condition.toString());
        }
        updateFor.append(" END");
        return Expression.x(updateFor.toString());
    }

    public Expression end() {
        return this.when(null);
    }
}

