/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.query;

import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.PrelocatedRequest;
import com.couchbase.client.core.message.query.QueryRequest;
import java.net.InetAddress;

public class GenericQueryRequest
extends AbstractCouchbaseRequest
implements QueryRequest,
PrelocatedRequest {
    private final String query;
    private final boolean jsonFormat;
    private final InetAddress targetNode;

    private GenericQueryRequest(String query, boolean jsonFormat, String bucket, String password, InetAddress targetNode) {
        super(bucket, password);
        this.query = query;
        this.jsonFormat = jsonFormat;
        this.targetNode = targetNode;
    }

    public String query() {
        return this.query;
    }

    public boolean isJsonFormat() {
        return this.jsonFormat;
    }

    @Override
    public InetAddress sendTo() {
        return this.targetNode;
    }

    public static GenericQueryRequest simpleStatement(String statement, String bucket, String password) {
        return new GenericQueryRequest(statement, false, bucket, password, null);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String password) {
        return new GenericQueryRequest(jsonQuery, true, bucket, password, null);
    }

    public static GenericQueryRequest jsonQuery(String jsonQuery, String bucket, String password, InetAddress targetNode) {
        return new GenericQueryRequest(jsonQuery, true, bucket, password, targetNode);
    }
}

