/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.status;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.accounting.aggregator.aggregation.AggregationInfo;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceFactory;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStateEvent;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStatus {
    private static Logger logger = LoggerFactory.getLogger(AggregationStatus.class);
    protected AggregationInfo aggregationInfo;
    @JsonProperty
    protected UUID uuid;
    @JsonProperty
    protected int originalRecordsNumber;
    @JsonProperty
    protected int aggregatedRecordsNumber;
    @JsonProperty
    protected int recoveredRecordNumber;
    @JsonProperty
    protected int malformedRecordNumber;
    @JsonProperty
    protected float percentage;
    @JsonProperty(required=false)
    protected String context;
    @JsonProperty
    protected int restartFrom;
    @JsonProperty(required=false)
    protected AggregationStatus previous;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty
    protected AggregationState aggregationState;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS Z")
    protected Calendar lastUpdateTime;
    @JsonProperty
    protected List<AggregationStateEvent> aggregationStateEvents;

    protected AggregationStatus() {
    }

    public static AggregationStatus getLast(String recordType, AggregationType aggregationType, Date aggregationStartDate, Date aggregationEndDate) throws Exception {
        return AggregatorPersistenceFactory.getAggregatorPersistenceStatus().getLast(recordType, aggregationType, aggregationStartDate, aggregationEndDate);
    }

    public static List<AggregationStatus> getUnterminated(String recordType, AggregationType aggregationType, boolean forceEarlyAggregation) throws Exception {
        return AggregatorPersistenceFactory.getAggregatorPersistenceStatus().getUnterminated(recordType, aggregationType, null, null, forceEarlyAggregation);
    }

    public static AggregationStatus getAggregationStatus(String recordType, AggregationType aggregationType, Date aggregationStartDate) throws Exception {
        return AggregatorPersistenceFactory.getAggregatorPersistenceStatus().getAggregationStatus(recordType, aggregationType, aggregationStartDate);
    }

    public AggregationStatus(AggregationInfo aggregationInfo) throws Exception {
        this.aggregationInfo = aggregationInfo;
        this.aggregationStateEvents = new ArrayList<AggregationStateEvent>();
        this.uuid = UUID.randomUUID();
        this.malformedRecordNumber = 0;
        this.previous = null;
        this.restartFrom = 0;
    }

    public AggregationStatus(AggregationStatus aggregationStatus) throws Exception {
        this.aggregationInfo = new AggregationInfo(aggregationStatus.getAggregationInfo());
        this.aggregationStateEvents = new ArrayList<AggregationStateEvent>();
        this.uuid = aggregationStatus.getUUID();
        this.malformedRecordNumber = 0;
        this.previous = aggregationStatus;
        this.restartFrom = 0;
    }

    public AggregationInfo getAggregationInfo() {
        return this.aggregationInfo;
    }

    public synchronized void setAggregationState(AggregationState aggregationState, Calendar startTime, boolean sync) throws Exception {
        Calendar endTime = Utility.getUTCCalendarInstance();
        logger.info("Going to Set {} for {} to {}. StartTime {}, EndTime {} [Duration : {}]", new Object[]{AggregationState.class.getSimpleName(), this.aggregationInfo, aggregationState.name(), Constant.DEFAULT_DATE_FORMAT.format(startTime.getTime()), Constant.DEFAULT_DATE_FORMAT.format(endTime.getTime()), Utility.getHumanReadableDuration(endTime.getTimeInMillis() - startTime.getTimeInMillis())});
        this.aggregationState = aggregationState;
        this.lastUpdateTime = endTime;
        this.restartFrom = 0;
        AggregationStateEvent aggregationStatusEvent = new AggregationStateEvent(aggregationState, startTime, endTime);
        this.aggregationStateEvents.add(aggregationStatusEvent);
        if (sync) {
            AggregatorPersistenceFactory.getAggregatorPersistenceStatus().upsertAggregationStatus(this);
        }
    }

    public void setRecordNumbers(int originalRecordsNumber, int aggregatedRecordsNumber, int malformedRecordNumber) {
        this.recoveredRecordNumber = originalRecordsNumber - aggregatedRecordsNumber;
        this.percentage = originalRecordsNumber != 0 ? (float)(100 * this.recoveredRecordNumber / originalRecordsNumber) : 0.0f;
        logger.info("Original records are {} ({} were malformed). Aggregated records are {}. Difference {}. We recover {}% of Documents", new Object[]{originalRecordsNumber, malformedRecordNumber, aggregatedRecordsNumber, this.recoveredRecordNumber, Float.valueOf(this.percentage)});
        this.malformedRecordNumber = malformedRecordNumber;
        this.originalRecordsNumber = originalRecordsNumber;
        this.aggregatedRecordsNumber = aggregatedRecordsNumber;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public void setAggregation(AggregationInfo aggregation) {
        this.aggregationInfo = aggregation;
    }

    public int getOriginalRecordsNumber() {
        return this.originalRecordsNumber;
    }

    public int getAggregatedRecordsNumber() {
        return this.aggregatedRecordsNumber;
    }

    public int getRecoveredRecordNumber() {
        return this.recoveredRecordNumber;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public AggregationState getAggregationState() {
        return this.aggregationState;
    }

    public void setAggregationState(AggregationState aggregationState) {
        this.aggregationState = aggregationState;
    }

    public List<AggregationStateEvent> getAggregationStateEvents() {
        return this.aggregationStateEvents;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public int getRestartFrom() {
        return this.restartFrom;
    }

    public void setRestartFrom(int restartFrom, boolean sync) throws Exception {
        this.restartFrom = restartFrom;
        if (sync) {
            AggregatorPersistenceFactory.getAggregatorPersistenceStatus().upsertAggregationStatus(this);
        }
    }

    public AggregationStatus getPrevious() {
        return this.previous;
    }

    public int getMalformedRecordNumber() {
        return this.malformedRecordNumber;
    }

    public void setMalformedRecordNumber(int malformedRecordNumber) {
        this.malformedRecordNumber = malformedRecordNumber;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void updateLastUpdateTime(boolean sync) throws Exception {
        this.lastUpdateTime = Utility.getUTCCalendarInstance();
        if (sync) {
            AggregatorPersistenceFactory.getAggregatorPersistenceStatus().upsertAggregationStatus(this);
        }
    }
}

