/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.persist;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.aggregator.persist.DocumentElaboration;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceFactory;
import org.gcube.accounting.aggregator.persistence.AggregatorPersistenceSrc;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStatus;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.documentstore.records.DSMapper;

public class DeleteDocument
extends DocumentElaboration {
    protected AggregatorPersistenceSrc aggregatorPersistenceSrc;
    protected ArrayNode arrayNode = DSMapper.getObjectMapper().createArrayNode();

    public DeleteDocument(AggregationStatus aggregationStatus, File file) throws Exception {
        super(aggregationStatus, AggregationState.DELETED, file, aggregationStatus.getOriginalRecordsNumber());
        this.aggregatorPersistenceSrc = AggregatorPersistenceFactory.getAggregatorPersistenceSrc();
    }

    @Override
    protected void elaborateLine(String line) throws Exception {
        JsonNode jsonNode = DSMapper.asJsonNode((String)line);
        if (this.aggregatorPersistenceSrc.isBulkDeleteAllowed()) {
            this.arrayNode.add(jsonNode);
            if (this.arrayNode.size() >= this.effectiveMaxRowPerStep) {
                this.aggregatorPersistenceSrc.deleteRecords(this.arrayNode);
                this.arrayNode = DSMapper.getObjectMapper().createArrayNode();
            }
        } else {
            String id = jsonNode.get("id").asText();
            this.logger.trace("Going to delete record with id {}", (Object)id);
            this.aggregatorPersistenceSrc.deleteRecord(jsonNode);
            TimeUnit.MILLISECONDS.sleep(2L);
        }
    }

    @Override
    protected void afterElaboration() throws Exception {
        if (this.aggregatorPersistenceSrc.isBulkDeleteAllowed() && this.arrayNode.size() > 0) {
            this.aggregatorPersistenceSrc.deleteRecords(this.arrayNode);
            this.arrayNode = DSMapper.getObjectMapper().createArrayNode();
        }
    }
}

