/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.status;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.accounting.aggregator.aggregation.AggregationInfo;
import org.gcube.accounting.aggregator.aggregation.AggregationType;
import org.gcube.accounting.aggregator.persistence.CouchBaseConnector;
import org.gcube.accounting.aggregator.status.AggregationState;
import org.gcube.accounting.aggregator.status.AggregationStateEvent;
import org.gcube.accounting.aggregator.utility.Constant;
import org.gcube.accounting.aggregator.utility.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStatus {
    private static Logger logger = LoggerFactory.getLogger(AggregationStatus.class);
    protected AggregationInfo aggregationInfo;
    @JsonProperty
    protected UUID uuid;
    @JsonProperty
    protected int originalRecordsNumber;
    @JsonProperty
    protected int aggregatedRecordsNumber;
    @JsonProperty
    protected int recoveredRecordNumber;
    @JsonProperty
    protected float percentage;
    @JsonProperty(required=false)
    protected String context;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty
    protected AggregationState aggregationState;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS Z")
    protected Calendar lastUpdateTime;
    @JsonProperty
    protected List<AggregationStateEvent> aggregationStateEvents;

    private AggregationStatus() {
    }

    public static AggregationStatus getLast(String recordType, AggregationType aggregationType) throws Exception {
        return CouchBaseConnector.getLast(recordType, aggregationType);
    }

    public static List<AggregationStatus> getUnterminated(String recordType, AggregationType aggregationType) throws Exception {
        return CouchBaseConnector.getUnterminated(recordType, aggregationType);
    }

    public static AggregationStatus getAggregationStatus(String recordType, AggregationType aggregationType, Date aggregationStartDate) throws Exception {
        return CouchBaseConnector.getAggregationStatus(recordType, aggregationType, aggregationStartDate);
    }

    public AggregationStatus(AggregationInfo aggregationInfo) throws Exception {
        this.aggregationInfo = aggregationInfo;
        this.aggregationStateEvents = new ArrayList<AggregationStateEvent>();
        this.uuid = UUID.randomUUID();
    }

    public AggregationInfo getAggregationInfo() {
        return this.aggregationInfo;
    }

    public synchronized void setState(AggregationState aggregationState, Calendar startTime, boolean sync) throws Exception {
        Calendar endTime = Utility.getUTCCalendarInstance();
        logger.info("Going to Set {} for {} to {}. StartTime {}, EndTime {} [Duration : {}]", new Object[]{AggregationState.class.getSimpleName(), this.aggregationInfo, aggregationState.name(), Constant.DEFAULT_DATE_FORMAT.format(startTime.getTime()), Constant.DEFAULT_DATE_FORMAT.format(endTime.getTime()), Utility.getHumanReadableDuration(endTime.getTimeInMillis() - startTime.getTimeInMillis())});
        this.aggregationState = aggregationState;
        this.lastUpdateTime = endTime;
        AggregationStateEvent aggregationStatusEvent = new AggregationStateEvent(aggregationState, startTime, endTime);
        this.aggregationStateEvents.add(aggregationStatusEvent);
        if (sync) {
            CouchBaseConnector.upsertAggregationStatus(this);
        }
    }

    public void setRecordNumbers(int originalRecordsNumber, int aggregatedRecordsNumber) {
        this.recoveredRecordNumber = originalRecordsNumber - aggregatedRecordsNumber;
        this.percentage = originalRecordsNumber != 0 ? (float)(100 * this.recoveredRecordNumber / originalRecordsNumber) : 0.0f;
        logger.info("Original records are {}. Aggregated records are {}. Difference {}. We recover {}% of Documents", new Object[]{originalRecordsNumber, aggregatedRecordsNumber, this.recoveredRecordNumber, Float.valueOf(this.percentage)});
        this.originalRecordsNumber = originalRecordsNumber;
        this.aggregatedRecordsNumber = aggregatedRecordsNumber;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setAggregation(AggregationInfo aggregation) {
        this.aggregationInfo = aggregation;
    }

    public int getOriginalRecordsNumber() {
        return this.originalRecordsNumber;
    }

    public int getAggregatedRecordsNumber() {
        return this.aggregatedRecordsNumber;
    }

    public AggregationState getAggregationState() {
        return this.aggregationState;
    }

    public List<AggregationStateEvent> getAggregationStateEvents() {
        return this.aggregationStateEvents;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}

