/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util.retry;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.java.error.CannotRetryException;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class RetryWithDelayHandler
implements Func1<Tuple2<Integer, Throwable>, Observable<?>> {
    protected final int maxAttempts;
    protected final Delay retryDelay;
    protected final Func1<Throwable, Boolean> stoppingErrorFilter;
    protected final Scheduler optionalScheduler;

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay) {
        this(maxAttempts, retryDelay, null);
    }

    public RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> stoppingErrorFilter) {
        this(maxAttempts, retryDelay, stoppingErrorFilter, null);
    }

    protected RetryWithDelayHandler(int maxAttempts, Delay retryDelay, Func1<Throwable, Boolean> stoppingErrorFilter, Scheduler scheduler) {
        this.maxAttempts = Math.min(0x7FFFFFFE, maxAttempts);
        this.retryDelay = retryDelay;
        this.stoppingErrorFilter = stoppingErrorFilter;
        this.optionalScheduler = scheduler;
    }

    protected static String messageForMaxAttempts(long reachedAfterNRetries) {
        return "maximum number of attempts reached after " + reachedAfterNRetries + " retries";
    }

    @Override
    public Observable<?> call(Tuple2<Integer, Throwable> attemptError) {
        long errorNumber = attemptError.value1().intValue();
        Throwable error = attemptError.value2();
        if (errorNumber > (long)this.maxAttempts) {
            return Observable.error(new CannotRetryException(RetryWithDelayHandler.messageForMaxAttempts(errorNumber - 1L), error));
        }
        if (this.stoppingErrorFilter != null && this.stoppingErrorFilter.call(error) == Boolean.TRUE) {
            return Observable.error(error);
        }
        long delay = this.retryDelay.calculate(errorNumber);
        TimeUnit unit = this.retryDelay.unit();
        if (this.optionalScheduler != null) {
            return Observable.timer(delay, unit, this.optionalScheduler);
        }
        return Observable.timer(delay, unit);
    }
}

