/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.privilegemanager;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.privilegemanager.PrivilegeManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRPrivilegeManager
implements PrivilegeManager {
    private Logger logger = LoggerFactory.getLogger(JCRPrivilegeManager.class);
    public static Map<String, GCoreEndpoint.Profile.Endpoint> servlets;

    public JCRPrivilegeManager() {
        servlets = JCRRepository.servlets;
    }

    @Override
    public void createCostumePrivilege(String name, String[] privileges) throws InternalErrorException {
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            StringBuilder aggregateName = null;
            if (privileges != null) {
                aggregateName = new StringBuilder();
                for (String privilege : privileges) {
                    aggregateName.append("&privilege=" + privilege);
                }
            }
            try {
                String requestUrl = servlets.get("") + "/CreateCostumePrivilegeServlet?&name=" + name + aggregateName;
                this.logger.debug(requestUrl);
                getMethod = new GetMethod(requestUrl);
                httpClient.executeMethod(getMethod);
                this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            }
            catch (Exception e) {
                this.logger.error("Error executing Costume Privilege", (Throwable)e);
            }
            XStream xstream = new XStream();
            Boolean modified = true;
            try {
                modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            }
            catch (Exception e) {
                this.logger.error("Error in create Costume Privilege", (Throwable)e);
            }
            if (modified.booleanValue()) {
                this.logger.debug(name + " Privilege created");
            } else {
                this.logger.debug(name + " Privilege has not been created");
            }
        }
        catch (Exception e) {
            this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }
}

