/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class EditorHook
implements CommitHook {
    private final EditorProvider provider;

    public EditorHook(@Nonnull EditorProvider provider) {
        this.provider = Preconditions.checkNotNull(provider);
    }

    @Override
    @Nonnull
    public NodeState processCommit(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull CommitInfo info) throws CommitFailedException {
        Preconditions.checkNotNull(before);
        Preconditions.checkNotNull(after);
        Preconditions.checkNotNull(info);
        NodeBuilder builder = after.builder();
        Editor editor = this.provider.getRootEditor(before, after, builder, info);
        CommitFailedException exception = EditorDiff.process(editor, before, after);
        if (exception == null) {
            return builder.getNodeState();
        }
        throw exception;
    }
}

