/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;

class JcrAllCommitHook
implements PostValidationHook,
PrivilegeConstants {
    JcrAllCommitHook() {
    }

    @Override
    @Nonnull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        NodeBuilder builder = after.builder();
        after.compareAgainstBaseState(before, new PrivilegeDiff(null, null, builder));
        return builder.getNodeState();
    }

    private final class PrivilegeDiff
    extends DefaultNodeStateDiff {
        private static final String ROOT_PATH = "";
        private final String path;
        private final NodeBuilder nodeBuilder;

        private PrivilegeDiff(PrivilegeDiff parentDiff, String nodeName, NodeBuilder nodeBuilder) {
            this.path = nodeName == null ? ROOT_PATH : parentDiff.path + '/' + nodeName;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if ("/jcr:system/rep:privileges".equals(this.path) && !"jcr:all".equals(name)) {
                NodeBuilder jcrAll = this.nodeBuilder.child("jcr:all");
                PropertyState aggregates = jcrAll.getProperty("rep:aggregates");
                PropertyBuilder<String> propertyBuilder = aggregates == null ? PropertyBuilder.array(Type.NAME, "rep:aggregates") : PropertyBuilder.copy(Type.NAME, aggregates);
                if (!propertyBuilder.hasValue(name)) {
                    propertyBuilder.addValue(name);
                    jcrAll.setProperty(propertyBuilder.getPropertyState());
                }
                if (!after.hasProperty("rep:aggregates")) {
                    PrivilegeBits bits = PrivilegeBits.getInstance(after.getProperty("rep:bits"));
                    PrivilegeBits all = PrivilegeBits.getInstance(jcrAll.getProperty("rep:bits"));
                    jcrAll.setProperty(PrivilegeBits.getInstance(all).add(bits).asPropertyState("rep:bits"));
                }
            }
            return true;
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (ROOT_PATH.equals(this.path) || Text.isDescendant(this.path, "/jcr:system/rep:privileges")) {
                after.compareAgainstBaseState(before, new PrivilegeDiff(this, name, this.nodeBuilder.child(name)));
            }
            return true;
        }
    }
}

