/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoVersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionGarbageCollector {
    private final DocumentNodeStore nodeStore;
    private final VersionGCSupport versionStore;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Set<NodeDocument.SplitDocType> GC_TYPES = Collections.emptySet();

    VersionGarbageCollector(DocumentNodeStore nodeStore) {
        this.nodeStore = nodeStore;
        this.versionStore = nodeStore.getDocumentStore() instanceof MongoDocumentStore ? new MongoVersionGCSupport((MongoDocumentStore)nodeStore.getDocumentStore()) : new VersionGCSupport(nodeStore.getDocumentStore());
    }

    public VersionGCStats gc(long maxRevisionAge, TimeUnit unit) {
        long maxRevisionAgeInMillis = unit.toMillis(maxRevisionAge);
        Stopwatch sw = Stopwatch.createStarted();
        VersionGCStats stats = new VersionGCStats();
        long oldestRevTimeStamp = this.nodeStore.getClock().getTime() - maxRevisionAgeInMillis;
        Revision headRevision = this.nodeStore.getHeadRevision();
        this.log.info("Starting revision garbage collection. Revisions older than [{}] would be removed", (Object)Utils.timestampToString(oldestRevTimeStamp));
        Revision checkpoint = this.nodeStore.getCheckpoints().getOldestRevisionToKeep();
        if (checkpoint != null && checkpoint.getTimestamp() < oldestRevTimeStamp) {
            this.log.info("Ignoring version gc as valid checkpoint [{}] found while need to collect versions older than [{}]", (Object)checkpoint.toReadableString(), (Object)Utils.timestampToString(oldestRevTimeStamp));
            stats.ignoredGCDueToCheckPoint = true;
            return stats;
        }
        this.collectDeletedDocuments(stats, headRevision, oldestRevTimeStamp);
        sw.stop();
        this.log.info("Version garbage collected in {}. {}", (Object)sw, (Object)stats);
        return stats;
    }

    private void collectSplitDocuments(VersionGCStats stats, long oldestRevTimeStamp) {
        int count = this.versionStore.deleteSplitDocuments(GC_TYPES, oldestRevTimeStamp);
        stats.splitDocGCCount += count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDeletedDocuments(VersionGCStats stats, Revision headRevision, long oldestRevTimeStamp) {
        ArrayList<String> docIdsToDelete = new ArrayList<String>();
        Iterable<NodeDocument> itr = this.versionStore.getPossiblyDeletedDocs(oldestRevTimeStamp);
        try {
            for (NodeDocument doc : itr) {
                if (doc.getNodeAtRevision(this.nodeStore, headRevision, null) != null) continue;
                docIdsToDelete.add(doc.getId());
                for (NodeDocument prevDoc : ImmutableList.copyOf(doc.getAllPreviousDocs())) {
                    docIdsToDelete.add(prevDoc.getId());
                }
            }
        }
        finally {
            Utils.closeIfCloseable(itr);
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Deleted document with following ids were deleted as part of GC \n");
            Joiner.on(StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable<?>)docIdsToDelete);
            this.log.debug(sb.toString());
        }
        this.nodeStore.getDocumentStore().remove(Collection.NODES, docIdsToDelete);
        this.nodeStore.invalidateDocChildrenCache();
        stats.deletedDocGCCount += docIdsToDelete.size();
    }

    public static class VersionGCStats {
        boolean ignoredGCDueToCheckPoint;
        int deletedDocGCCount;
        int splitDocGCCount;

        public String toString() {
            return "VersionGCStats{ignoredGCDueToCheckPoint=" + this.ignoredGCDueToCheckPoint + ", deletedDocGCCount=" + this.deletedDocGCCount + ", splitDocGCCount=" + this.splitDocGCCount + '}';
        }
    }
}

