/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.versioning;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibary.model.versioning.WorkspaceVersion;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.TokenUtility;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRVersioning {
    private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
    Map<String, GCoreEndpoint.Profile.Endpoint> servlets = JCRRepository.servlets;
    private String portalLogin;

    public JCRVersioning(String portalLogin) {
        this.portalLogin = portalLogin;
    }

    public List<WorkspaceVersion> getVersionHistory(String id) throws InternalErrorException {
        List list = null;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("VersionHistory").uri().toString() + "?" + "id" + "=" + id + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            httpClient.executeMethod(getMethod);
            this.logger.trace("Calling List Version History Servlet");
            XStream xstream = new XStream();
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving version history for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return list;
    }

    public void saveCurrentVersion(String id, String remotePath) throws InternalErrorException {
        this.logger.trace("Calling Save Current Version Servlet");
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("SaveCurrentVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "remotePath" + "=" + URLEncoder.encode(remotePath, "UTF-8") + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error saving current version for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public void restoreVersion(String id, String remotePath, String version) throws InternalErrorException {
        this.logger.trace("Calling Restore Version History Servlet");
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("RestoreVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "remotePath" + "=" + URLEncoder.encode(remotePath, "UTF-8") + "&" + "version" + "=" + version + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error restoring version for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public void removeVersion(String id, String remotePath, String versionID) throws InternalErrorException {
        this.logger.trace("Calling Remove Version History Servlet");
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("RemoveVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "version" + "=" + versionID + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        catch (Exception e) {
            this.logger.error("Error removing versioning for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public WorkspaceVersion getVersion(String itemID, String versionID) throws InternalErrorException {
        WorkspaceVersion version;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("GetVersion").uri().toString() + "?" + "id" + "=" + itemID + "&" + "version" + "=" + versionID + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            XStream xstream = new XStream();
            version = (WorkspaceVersion)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error getting versioning for node " + itemID, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return version;
    }

    public WorkspaceVersion getCurrentVersion(String id) throws InternalErrorException {
        WorkspaceVersion version;
        HttpMethodBase getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(this.servlets.get("GetCurrentVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "login" + "=" + this.portalLogin);
            TokenUtility.setHeader((GetMethod)getMethod);
            int response = httpClient.executeMethod(getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            XStream xstream = new XStream();
            version = (WorkspaceVersion)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error getting versioning for node " + id, (Throwable)e);
            throw new InternalErrorException(e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return version;
    }

    public InputStream downloadVersion(String id, String version) throws InternalErrorException, IOException {
        String fileURL = this.servlets.get("DownloadVersion").uri().toString() + "?" + "id" + "=" + id + "&" + "version" + "=" + version + "&" + "login" + "=" + this.portalLogin;
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        TokenUtility.setHeader(httpConn);
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = httpConn.getInputStream();
            return inputStream;
        }
        throw new InternalErrorException("No file to download. Server replied HTTP code: " + responseCode);
    }
}

