/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class CloseableIterable<T>
implements Iterable<T>,
Closeable {
    private final Iterable<T> iterable;
    private final Closeable closeable;

    public static <T> CloseableIterable<T> wrap(Iterable<T> iterable, Closeable closeable) {
        return new CloseableIterable<T>(iterable, closeable);
    }

    public static <T> CloseableIterable<T> wrap(Iterable<T> iterable) {
        return new CloseableIterable<T>(iterable, null);
    }

    public CloseableIterable(Iterable<T> iterable, Closeable closeable) {
        this.iterable = iterable;
        this.closeable = closeable;
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterable.iterator();
    }
}

