/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.common.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.common.homelibrary.jcr.importing.ImportContentManagerItemRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportQueryRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportRequest;
import org.gcube.common.homelibrary.jcr.importing.ImportUrlRequest;
import org.gcube.common.homelibrary.jcr.importing.JCRWorkspaceFolderItemImporter;
import org.gcube.common.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFolderBulkCreator
implements FolderBulkCreator {
    private static final String STATUS = "hl:status";
    private static final String FAILURES = "hl:failures";
    private static final String REQUESTS = "hl:requests";
    private String id;
    private String nodeId;
    private JCRWorkspaceFolder folder;
    private JCRFolderBulkCreatorManager manager;
    private List<ImportRequest> requests = new LinkedList<ImportRequest>();
    private boolean commited = false;
    private Logger logger = LoggerFactory.getLogger(JCRFolderBulkCreator.class);
    private final JCRWorkspace workspace;

    public JCRFolderBulkCreator(JCRWorkspace workspace, ItemDelegate node, JCRFolderBulkCreatorManager manager) throws RepositoryException, InternalErrorException {
        this.workspace = workspace;
        this.manager = manager;
        this.commited = true;
        this.id = node.getName();
        this.nodeId = node.getId();
    }

    public JCRFolderBulkCreator(String id, JCRWorkspaceFolder folder, JCRFolderBulkCreatorManager manager) throws InternalErrorException {
        this.workspace = folder.getWorkspace();
        this.commited = false;
        this.id = id;
        this.folder = folder;
        this.manager = manager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void createMetadata(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        this.requests.add(ImportContentManagerItemRequest.metadataRequest(uri));
    }

    @Override
    public void createAnnotation(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        this.requests.add(ImportContentManagerItemRequest.annotationRequest(uri));
    }

    @Override
    public void createDocumentPartItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
    }

    @Override
    public void createDocumentAlternativeItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        this.requests.add(ImportContentManagerItemRequest.alternativeRequest(uri));
    }

    @Override
    public void createDocumentItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        this.requests.add(ImportContentManagerItemRequest.documentRequest(uri));
    }

    @Override
    public void createExternalUrl(String url) throws InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (url == null) {
            throw new IllegalArgumentException("The url can't be null.");
        }
        this.requests.add(new ImportUrlRequest(url));
    }

    @Override
    public void createQuery(String name, String query, QueryType queryType) throws InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (name == null || query == null || queryType == null) {
            throw new IllegalArgumentException("name, query or queryType null");
        }
        this.requests.add(new ImportQueryRequest(name, query, queryType));
    }

    private void saveFolderBulkCreator() throws InternalErrorException {
    }

    @Override
    public void commit() throws InternalErrorException {
        this.logger.debug("Request commited");
        if (this.commited) {
            throw new IllegalStateException("This FolderBulkCreator has already commited");
        }
        this.commited = true;
        if (this.requests.size() == 0) {
            this.logger.debug("No request was submitted");
            return;
        }
        JCRWorkspaceFolderItemImporter folderItemImporter = new JCRWorkspaceFolderItemImporter(this.manager, this.getId(), this.requests, this.folder);
        Thread fiiThread = new Thread((Runnable)folderItemImporter, "FolderItemImporter");
        this.manager.addFolderBulkCreator(this, fiiThread);
        this.saveFolderBulkCreator();
        this.logger.debug("Start importer");
        fiiThread.start();
    }

    @Override
    public WorkspaceFolder getDestinationFolder() {
        return this.folder;
    }

    @Override
    public int getNumberOfRequests() throws InternalErrorException {
        if (this.nodeId == null) {
            return this.requests.size();
        }
        return 0;
    }

    @Override
    public float getStatus() throws InternalErrorException {
        if (this.nodeId == null) {
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public int getFailures() throws InternalErrorException {
        if (this.nodeId == null) {
            return 0;
        }
        return 0;
    }

    @Override
    public void remove() throws InternalErrorException {
        this.manager.removeThread(this.id);
        if (this.nodeId == null) {
            return;
        }
    }
}

