/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SubtreeEditor
extends DefaultEditor {
    private final Editor editor;
    private final String[] path;
    private final int depth;

    private SubtreeEditor(Editor editor, String[] path, int depth) {
        this.editor = Preconditions.checkNotNull(editor);
        this.path = Preconditions.checkNotNull(path);
        Preconditions.checkElementIndex(depth, path.length);
        this.depth = depth;
    }

    public SubtreeEditor(Editor editor, String ... path) {
        this(editor, path, 0);
    }

    private Editor descend(String name) {
        if (!name.equals(this.path[this.depth])) {
            return null;
        }
        if (this.depth + 1 < this.path.length) {
            return new SubtreeEditor(this.editor, this.path, this.depth + 1);
        }
        return this.editor;
    }

    @Override
    @CheckForNull
    public Editor childNodeAdded(String name, NodeState after) {
        return this.descend(name);
    }

    @Override
    @CheckForNull
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return this.descend(name);
    }

    @Override
    @CheckForNull
    public Editor childNodeDeleted(String name, NodeState before) {
        return this.descend(name);
    }
}

