/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.OrderedPropertyIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexLookup;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedPropertyIndex
extends PropertyIndex
implements QueryIndex.AdvancedQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedPropertyIndex.class);

    @Override
    public String getIndexName() {
        return "ordered";
    }

    @Override
    PropertyIndexLookup getLookup(NodeState root) {
        return new OrderedPropertyIndexLookup(root);
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    private static QueryIndex.IndexPlan.Builder getIndexPlanBuilder(Filter filter) {
        QueryIndex.IndexPlan.Builder b = new QueryIndex.IndexPlan.Builder();
        b.setCostPerExecution(1.0);
        b.setCostPerEntry(1.3);
        b.setFulltextIndex(false);
        b.setIncludesNodeData(false);
        b.setFilter(filter);
        b.setDelayed(false);
        return b;
    }

    @Override
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState root) {
        LOG.debug("getPlans(Filter, List<OrderEntry>, NodeState)");
        LOG.debug("getPlans() - filter: {} - ", (Object)filter);
        LOG.debug("getPlans() - sortOrder: {} - ", sortOrder);
        LOG.debug("getPlans() - rootState: {} - ", (Object)root);
        ArrayList<QueryIndex.IndexPlan> plans = new ArrayList<QueryIndex.IndexPlan>();
        PropertyIndexLookup pil = this.getLookup(root);
        if (pil instanceof OrderedPropertyIndexLookup) {
            String propertyName;
            OrderedPropertyIndexLookup lookup = (OrderedPropertyIndexLookup)pil;
            Collection<Filter.PropertyRestriction> restrictions = filter.getPropertyRestrictions();
            if (sortOrder != null) {
                for (QueryIndex.OrderEntry oe : sortOrder) {
                    propertyName = PathUtils.getName(oe.getPropertyName());
                    if (!lookup.isIndexed(propertyName, "/", filter)) continue;
                    QueryIndex.IndexPlan.Builder b = OrderedPropertyIndex.getIndexPlanBuilder(filter);
                    b.setSortOrder(ImmutableList.of(new QueryIndex.OrderEntry(oe.getPropertyName(), Type.UNDEFINED, lookup.isAscending(root, propertyName, filter) ? QueryIndex.OrderEntry.Order.ASCENDING : QueryIndex.OrderEntry.Order.DESCENDING)));
                    b.setEstimatedEntryCount(lookup.getEstimatedEntryCount(propertyName, null, filter, null));
                    QueryIndex.IndexPlan plan = b.build();
                    LOG.debug("plan: {}", (Object)plan);
                    plans.add(plan);
                }
            }
            for (Filter.PropertyRestriction pr : restrictions) {
                propertyName = PathUtils.getName(pr.propertyName);
                if (!lookup.isIndexed(propertyName, "/", filter)) continue;
                PropertyValue value = null;
                boolean createPlan = false;
                if (pr.first == null && pr.last == null) {
                    value = null;
                    createPlan = true;
                } else if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    value = pr.first;
                    createPlan = true;
                } else if (pr.first != null && !pr.first.equals(pr.last)) {
                    if (lookup.isAscending(root, propertyName, filter)) {
                        value = pr.first;
                        createPlan = true;
                    } else {
                        createPlan = false;
                    }
                } else if (pr.last != null && !pr.last.equals(pr.first)) {
                    if (!lookup.isAscending(root, propertyName, filter)) {
                        value = pr.last;
                        createPlan = true;
                    } else {
                        createPlan = false;
                    }
                }
                if (!createPlan) continue;
                QueryIndex.IndexPlan.Builder b = OrderedPropertyIndex.getIndexPlanBuilder(filter);
                b.setSortOrder(ImmutableList.of(new QueryIndex.OrderEntry(propertyName, Type.UNDEFINED, lookup.isAscending(root, propertyName, filter) ? QueryIndex.OrderEntry.Order.ASCENDING : QueryIndex.OrderEntry.Order.DESCENDING)));
                long count = lookup.getEstimatedEntryCount(propertyName, value, filter, pr);
                b.setEstimatedEntryCount(count);
                LOG.debug("estimatedCount: {}", (Object)count);
                QueryIndex.IndexPlan plan = b.build();
                LOG.debug("plan: {}", (Object)plan);
                plans.add(plan);
            }
        } else {
            LOG.error("Without an OrderedPropertyIndexLookup you should not end here");
        }
        return plans;
    }

    @Override
    public String getPlanDescription(QueryIndex.IndexPlan plan) {
        LOG.debug("getPlanDescription() - plan: {}", (Object)plan);
        LOG.error("Not implemented yet");
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Cursor query(QueryIndex.IndexPlan plan, NodeState root) {
        LOG.debug("query(IndexPlan, NodeState)");
        LOG.debug("query() - plan: {}", (Object)plan);
        LOG.debug("query() - rootState: {}", (Object)root);
        Filter filter = plan.getFilter();
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        Iterable<String> paths = null;
        Cursor cursor = null;
        PropertyIndexLookup pil = this.getLookup(root);
        if (pil instanceof OrderedPropertyIndexLookup) {
            String propertyName;
            OrderedPropertyIndexLookup lookup = (OrderedPropertyIndexLookup)pil;
            Collection<Filter.PropertyRestriction> prs = filter.getPropertyRestrictions();
            int depth = 1;
            for (Filter.PropertyRestriction pr : prs) {
                propertyName = PathUtils.getName(pr.propertyName);
                depth = PathUtils.getDepth(pr.propertyName);
                if (!lookup.isIndexed(propertyName, "/", filter)) continue;
                paths = lookup.query(filter, propertyName, pr);
            }
            if (paths == null && sortOrder != null && !sortOrder.isEmpty()) {
                for (QueryIndex.OrderEntry oe : sortOrder) {
                    propertyName = PathUtils.getName(oe.getPropertyName());
                    depth = PathUtils.getDepth(oe.getPropertyName());
                    if (!lookup.isIndexed(propertyName, "/", null)) continue;
                    paths = lookup.query(filter, propertyName, new Filter.PropertyRestriction());
                }
            }
            if (paths == null) {
                throw new IllegalStateException("OrderedPropertyIndex index is used even when no index is available for filter " + filter);
            }
            cursor = Cursors.newPathCursor(paths, filter.getQueryEngineSettings());
            if (depth > 1) {
                cursor = Cursors.newAncestorCursor(cursor, depth - 1, filter.getQueryEngineSettings());
            }
        } else {
            cursor = super.query(filter, root);
        }
        return cursor;
    }
}

