/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.CouchbaseCore;
import com.couchbase.client.core.RequestCancelledException;
import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.ResponseHandler;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;

public class RetryHelper {
    public static void retryOrCancel(CoreEnvironment environment, CouchbaseRequest request, EventSink<ResponseEvent> responseBuffer) {
        if (environment.retryStrategy().shouldRetry(request, environment)) {
            if (!responseBuffer.tryPublishEvent(ResponseHandler.RESPONSE_TRANSLATOR, request, request.observable())) {
                request.observable().onError(CouchbaseCore.BACKPRESSURE_EXCEPTION);
            }
        } else {
            request.observable().onError(new RequestCancelledException("Could not dispatch request, cancelling instead of retrying."));
        }
    }
}

