/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.kv.KeyValueAuthHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueFeatureHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueHandler;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheClientCodec;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class KeyValueEndpoint
extends AbstractEndpoint {
    public KeyValueEndpoint(String hostname, String bucket, String password, int port, CoreEnvironment env, RingBuffer<ResponseEvent> responseBuffer) {
        super(hostname, bucket, password, port, env, responseBuffer, false, env.kvIoPool() == null ? env.ioPool() : env.kvIoPool());
    }

    @Override
    protected void customEndpointHandlers(ChannelPipeline pipeline) {
        if (this.environment().keepAliveInterval() > 0L) {
            pipeline.addLast(new IdleStateHandler(this.environment().keepAliveInterval(), 0L, 0L, TimeUnit.MILLISECONDS));
        }
        pipeline.addLast(new BinaryMemcacheClientCodec()).addLast(new BinaryMemcacheObjectAggregator(Integer.MAX_VALUE)).addLast(new KeyValueAuthHandler(this.bucket(), this.password())).addLast(new KeyValueFeatureHandler(this.environment())).addLast(new KeyValueHandler(this, this.responseBuffer(), false, true));
    }
}

