/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.security.authorization.permission.AllPermissions;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissionImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.CompiledPermissions;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;

public class PermissionProviderImpl
implements PermissionProvider,
AccessControlConstants,
PermissionConstants {
    private final Root root;
    private final String workspaceName;
    private final AuthorizationConfiguration acConfig;
    private final CompiledPermissions compiledPermissions;
    private ImmutableRoot immutableRoot;

    public PermissionProviderImpl(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull AuthorizationConfiguration acConfig) {
        this.root = root;
        this.workspaceName = workspaceName;
        this.acConfig = acConfig;
        this.immutableRoot = PermissionProviderImpl.getImmutableRoot(root);
        this.compiledPermissions = principals.contains(SystemPrincipal.INSTANCE) || this.isAdmin(principals) ? AllPermissions.getInstance() : CompiledPermissionImpl.create(this.immutableRoot, workspaceName, principals, acConfig);
    }

    @Override
    public void refresh() {
        this.immutableRoot = PermissionProviderImpl.getImmutableRoot(this.root);
        this.compiledPermissions.refresh(this.immutableRoot, this.workspaceName);
    }

    @Override
    @Nonnull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return this.compiledPermissions.getPrivileges(this.getImmutableTree(tree));
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return this.compiledPermissions.hasPrivileges(this.getImmutableTree(tree), privilegeNames);
    }

    @Override
    public RepositoryPermission getRepositoryPermission() {
        return this.compiledPermissions.getRepositoryPermission();
    }

    @Override
    public TreePermission getTreePermission(@Nonnull Tree tree, @Nonnull TreePermission parentPermission) {
        return this.compiledPermissions.getTreePermission(this.getImmutableTree(tree), parentPermission);
    }

    @Override
    public boolean isGranted(@Nonnull Tree tree, @Nullable PropertyState property, long permissions) {
        return this.compiledPermissions.isGranted(this.getImmutableTree(tree), property, permissions);
    }

    @Override
    public boolean isGranted(@Nonnull String oakPath, @Nonnull String jcrActions) {
        Tree tree;
        TreeLocation location = TreeLocation.create(this.immutableRoot, oakPath);
        boolean isAcContent = this.acConfig.getContext().definesLocation(location);
        long permissions = Permissions.getPermissions(jcrActions, location, isAcContent);
        boolean isGranted = false;
        PropertyState property = location.getProperty();
        Tree tree2 = tree = property == null ? location.getTree() : location.getParent().getTree();
        if (tree != null) {
            isGranted = this.isGranted(tree, property, permissions);
        } else if (!PermissionProviderImpl.isVersionStorePath(oakPath)) {
            isGranted = this.compiledPermissions.isGranted(oakPath, permissions);
        }
        return isGranted;
    }

    private boolean isAdmin(Set<Principal> principals) {
        ImmutableSet<Object> adminNames = ImmutableSet.copyOf((Object[])this.acConfig.getParameters().getConfigValue("administrativePrincipals", new String[0]));
        for (Principal principal : principals) {
            if (!(principal instanceof AdminPrincipal) && !adminNames.contains(principal.getName())) continue;
            return true;
        }
        return false;
    }

    private ImmutableTree getImmutableTree(@Nullable Tree tree) {
        if (tree instanceof ImmutableTree) {
            return (ImmutableTree)tree;
        }
        return tree == null ? null : this.immutableRoot.getTree(tree.getPath());
    }

    private static ImmutableRoot getImmutableRoot(@Nonnull Root base) {
        if (base instanceof ImmutableRoot) {
            return (ImmutableRoot)base;
        }
        return new ImmutableRoot(base);
    }

    private static boolean isVersionStorePath(@Nonnull String oakPath) {
        if (oakPath.indexOf("jcr:system") == 1) {
            for (String p : VersionConstants.SYSTEM_PATHS) {
                if (!oakPath.startsWith(p)) continue;
                return true;
            }
        }
        return false;
    }
}

