/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.token;

import java.io.IOException;

import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;

import org.fao.fi.security.common.services.exceptions.BadRequestException;
import org.fao.fi.security.server.javax.filters.AbstractRequestValidatorFilter;
import org.fao.fi.security.server.providers.validators.SecuredResourceValidationServiceProvider;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 30 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 30 Apr 2014
 */
@Priority(value=Priorities.AUTHORIZATION)
abstract public class AbstractTokenSecuredResourceRequestValidatorFilter extends AbstractRequestValidatorFilter {
	protected SecuredResourceValidationServiceProvider _validator;
	
	/**
	 * Class constructor
	 *
	 * @param validator
	 */
	public AbstractTokenSecuredResourceRequestValidatorFilter(SecuredResourceValidationServiceProvider validator) {
		super();
		
		this._validator = validator;
	}
	
	@PostConstruct 
	private void logInitialization() {
		final String $THIS = this.getClass().getSimpleName() + "#" + this.hashCode();
		
		this._log.info("{} has been initialized with {}", $THIS, this._validator.getClass());
	}

	@Override
	public void filter(ContainerRequestContext requestContext) throws IOException {
		this._log.debug("Filtering request for {} with {}", requestContext.getUriInfo().getAbsolutePath(), this);
		
		try {
			if(!this._validator.validate(requestContext))
				requestContext.abortWith(
					errorResponse(Response.Status.UNAUTHORIZED, "You are not authorized to access this resource")
				);
		} catch(BadRequestException BRe) {
			requestContext.abortWith(
				errorResponse(Response.Status.BAD_REQUEST, BRe.getMessage())
			);
		} catch(Exception e) {
			requestContext.abortWith(
				errorResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())
			);
		}
	}
}