/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.origin.configuration;

import java.util.regex.Pattern;

import javax.naming.NamingException;

import org.fao.fi.security.common.support.configuration.AbstractJNDIConfiguration;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 8 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 8 May 2014
 */
public class RestrictedIPsJNDIConfiguration extends AbstractJNDIConfiguration implements RestrictedIPsConfiguration {
	private String _restrictedIPsValidationRegexpResource;
	
	/**
	 * Class constructor
	 */
	public RestrictedIPsJNDIConfiguration() throws NamingException {
		this("ip/validation/regexp");
	}

	/**
	 * Class constructor
	 *
	 * @param restrictedIPValidationRegexpResource
	 * @throws NamingException
	 */
	public RestrictedIPsJNDIConfiguration(String restrictedIPValidationRegexpResource) throws NamingException {
		super();
		
		this._restrictedIPsValidationRegexpResource = restrictedIPValidationRegexpResource;
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.origin.config.RestrictedIPsConfiguration#getValidationRegexp()
	 */
	@Override
	public String getValidationRegexp() {
		return this.getEnvResource(this._restrictedIPsValidationRegexpResource);
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.origin.config.RestrictedIPsConfiguration#getValidationPattern()
	 */
	@Override
	public Pattern getValidationPattern() { 
		return Pattern.compile(this.getValidationRegexp());
	}
	
	public String toString() {
		return this.getClass().getSimpleName() + " [ Validation REGEXP: " + this.getValidationRegexp() + " ]";
	}
}
