/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.bandwidth.configuration;


/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 8 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 8 May 2014
 */
public class BandwidthLimitedSimpleConfiguration implements BandwidthLimitedConfiguration {
	private Integer _maxRequests;
	private Integer _timeframe;
	
	/**
	 * Class constructor
	 *
	 * @param maxRequests
	 * @param timeframe
	 */
	public BandwidthLimitedSimpleConfiguration(Integer maxRequests, Integer timeframe) {
		super();
		this._maxRequests = maxRequests;
		this._timeframe = timeframe;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedConfiguration#getMaxRequests()
	 */
	@Override
	public Integer getMaxRequests() {
		return this._maxRequests;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedConfiguration#getTimeframe()
	 */
	@Override
	public Integer getTimeframe() {
		return this._timeframe;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [ Max. Requests: " + this._maxRequests + ", Timeframe: " + this._timeframe + " ]";
	}
}