/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.filters.bandwidth.configuration;

import javax.naming.NamingException;

import org.fao.fi.security.common.support.configuration.AbstractJNDIConfiguration;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 8 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 8 May 2014
 */
public class BandwidthLimitedJNDIConfiguration extends AbstractJNDIConfiguration implements BandwidthLimitedConfiguration {
	private String _maxRequestsResource;
	private String _timeframeResource;
	
	/**
	 * Class constructor
	 */
	public BandwidthLimitedJNDIConfiguration() throws NamingException {
		this("bandwidth/limit/requests", "bandwidth/limit/timeframe");
	}

	/**
	 * Class constructor
	 *
	 * @param maxRequestsResource
	 * @param timeframeResource
	 * @throws NamingException
	 */
	public BandwidthLimitedJNDIConfiguration(String maxRequestsResource, String timeframeResource) throws NamingException {
		super();
		this._maxRequestsResource = maxRequestsResource;
		this._timeframeResource = timeframeResource;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedConfiguration#getMaxRequests()
	 */
	@Override
	public Integer getMaxRequests() {
		return this.getEnvResource(this._maxRequestsResource);
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedConfiguration#getTimeframe()
	 */
	@Override
	public Integer getTimeframe() {
		return this.getEnvResource(this._timeframeResource);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [ Max. Requests: " + this.getMaxRequests() + ", Timeframe: " + this.getTimeframe() + " ]";
	}
}
