/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.javax.filters.bandwidth;

import java.io.IOException;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.fao.fi.security.server.javax.filters.AbstractRequestValidatorFilter;
import org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedConfiguration;
import org.fao.fi.security.server.javax.filters.bandwidth.configuration.BandwidthLimitedSimpleConfiguration;
import org.fao.fi.security.server.javax.filters.bandwidth.support.BandwidthLimitedResource;
import org.fao.fi.security.server.javax.filters.bandwidth.support.BandwidthLimiter;

@BandwidthLimitedResource
@Priority(value=1001)
public class BandwidthLimitedResourceRequestValidatorFilter
extends AbstractRequestValidatorFilter {
    protected static final String REQUESTS_BY_IP_CACHE_ID = "requests.cache";
    protected static final int MAX_IPS_IN_CACHE = 1000;
    protected static final int MAX_REQUESTS = 50;
    protected static final int TIMEFRAME = 10;
    @Context
    private HttpServletRequest _servletRequest;
    private BandwidthLimitedConfiguration _configuration;
    protected CacheManager _cacheManager;
    protected Cache _requestsByIPCache;

    @Inject
    public BandwidthLimitedResourceRequestValidatorFilter(@BandwidthLimiter BandwidthLimitedConfiguration configuration) {
        String $THIS = ((Object)((Object)this)).getClass().getSimpleName() + "#" + ((Object)((Object)this)).hashCode();
        this._configuration = configuration;
        if (this._configuration == null) {
            this._log.warn("No bandwidth limiter configuration provided for {}: using defaults...", (Object)this);
            this._configuration = new BandwidthLimitedSimpleConfiguration(50, 10);
        }
        this._cacheManager = CacheManager.getInstance();
        if (this._cacheManager == null) {
            this._cacheManager = CacheManager.create();
        }
        String cacheId = REQUESTS_BY_IP_CACHE_ID;
        this._log.info("Initializing {} with {} and cache ID {}", new Object[]{$THIS, this._cacheManager, cacheId});
        if (!this._cacheManager.cacheExists(cacheId)) {
            CacheConfiguration cacheConfiguration = new CacheConfiguration(cacheId, 1000);
            cacheConfiguration.eternal(false).timeToIdleSeconds((long)this._configuration.getTimeframe().intValue()).timeToLiveSeconds((long)this._configuration.getTimeframe().intValue()).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU).overflowToOffHeap(false);
            this._requestsByIPCache = new Cache(cacheConfiguration);
            this._cacheManager.addCacheIfAbsent((Ehcache)this._requestsByIPCache);
        }
        this._log.info("{} has been initialized with {}", (Object)$THIS, this._configuration.getClass());
    }

    @PostConstruct
    private void completeInitialization() {
        String $THIS = ((Object)((Object)this)).getClass().getSimpleName() + "#" + ((Object)((Object)this)).hashCode();
        this._log.info("{} has been initialized with {}", (Object)$THIS, (Object)this._configuration);
    }

    @Override
    protected String getSecurityScheme() {
        return "BANDWIDTH-LIMITER-FILTER";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            String actualHost;
            String host = this._servletRequest.getRemoteHost();
            String xff = requestContext.getHeaderString("X-FORWARDED-FOR");
            String string = actualHost = xff == null ? host : xff;
            if (actualHost != null) {
                actualHost = actualHost.replaceAll(":[0-9]+$", "");
            }
            this._log.debug("Intercepted a {} request for {} coming from host {} [ XFF: {} ]", new Object[]{requestContext.getMethod(), requestContext.getUriInfo().getAbsolutePath(), host, xff == null ? "NOT SET" : xff});
            RequestsByIP requestsByIP = null;
            long now = System.currentTimeMillis();
            Cache cache = this._requestsByIPCache;
            synchronized (cache) {
                Element currentRequestsElement = this._requestsByIPCache.get((Serializable)((Object)actualHost));
                if (currentRequestsElement == null) {
                    requestsByIP = RequestsByIP.newRequest();
                } else {
                    requestsByIP = (RequestsByIP)currentRequestsElement.getObjectValue();
                    requestsByIP.increaseRequests();
                }
                currentRequestsElement = new Element((Object)actualHost, (Object)requestsByIP);
                this._requestsByIPCache.put(currentRequestsElement);
            }
            if (requestsByIP._currentRequests > this._configuration.getMaxRequests()) {
                requestContext.abortWith(this.errorResponse(Response.Status.FORBIDDEN, "You have been prevented to access this resource"));
                this._log.warn("Blocked a {} request for {} coming from host {} [ XFF: {} ] having accounted for {} requests in the last {} seconds", new Object[]{requestContext.getMethod(), requestContext.getUriInfo().getAbsolutePath(), host, xff == null ? "NOT SET" : xff, requestsByIP._currentRequests, Math.round((double)(now - requestsByIP._firstRequest) * 0.001)});
            }
        }
        catch (Throwable t) {
            this._log.error("Unexpected {} caught: {}", new Object[]{t.getClass(), t.getMessage(), t});
            requestContext.abortWith(this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, t.getMessage()));
        }
    }

    private static class RequestsByIP {
        private long _firstRequest;
        private int _currentRequests;

        public RequestsByIP() {
            this(System.currentTimeMillis(), 0);
        }

        public RequestsByIP(long firstRequest, int currentRequests) {
            this._firstRequest = firstRequest;
            this._currentRequests = currentRequests;
        }

        public static RequestsByIP newRequest() {
            return new RequestsByIP(System.currentTimeMillis(), 1);
        }

        public long increaseRequests() {
            return ++this._currentRequests;
        }
    }
}

