/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.providers.validators.token.spi;

import java.net.InetAddress;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.services.exceptions.token.TokenProductionException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.fao.fi.security.common.utilities.EncryptionUtils;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.providers.validators.token.spi.TokenManager;
import org.fao.fi.security.server.providers.validators.token.spi.TokenProducer;

public abstract class AbstractTokenProducer
extends LoggingClient
implements TokenProducer {
    private TokenManager _tokenManager;
    private TokenProcessor _tokenProcessor;

    public AbstractTokenProducer(TokenManager tokenManager, TokenProcessor tokenProcessor) {
        this._tokenManager = tokenManager;
        this._tokenProcessor = tokenProcessor;
    }

    @Override
    public synchronized String createNewToken() throws TokenProductionException {
        try {
            boolean isValid = false;
            long nanos = -1L;
            long now = -1L;
            String token = null;
            String localhostIP = InetAddress.getLocalHost().getHostAddress();
            while (!isValid) {
                StringBuilder plainToken = new StringBuilder();
                now = System.currentTimeMillis();
                nanos = System.nanoTime();
                plainToken.append(now).append("|").append(nanos).append("|").append(localhostIP);
                token = EncryptionUtils.getMD5Sum((String)plainToken.toString());
                if (this._tokenManager.exists(token)) {
                    this._log.warn("Collision detected for token {} ( generated by {}|{}|{} )", new Object[]{token, now, nanos, localhostIP});
                    continue;
                }
                this._tokenManager.store(token);
                isValid = true;
            }
            return token;
        }
        catch (Throwable t) {
            throw new TokenProductionException(t.getMessage(), t);
        }
    }

    @Override
    public String process(String token) throws TokenProcessingException {
        return this._tokenProcessor.processAfterCreation(token);
    }
}

