/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.server.javax.filters.token;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.fao.fi.security.common.services.exceptions.BadRequestException;
import org.fao.fi.security.server.javax.filters.AbstractRequestValidatorFilter;
import org.fao.fi.security.server.providers.validators.SecuredResourceValidationServiceProvider;

@Priority(value=2000)
public abstract class AbstractTokenSecuredResourceRequestValidatorFilter
extends AbstractRequestValidatorFilter {
    protected SecuredResourceValidationServiceProvider _validator;

    public AbstractTokenSecuredResourceRequestValidatorFilter(SecuredResourceValidationServiceProvider validator) {
        this._validator = validator;
    }

    @PostConstruct
    private void logInitialization() {
        String $THIS = ((Object)((Object)this)).getClass().getSimpleName() + "#" + ((Object)((Object)this)).hashCode();
        this._log.info("{} has been initialized with {}", (Object)$THIS, this._validator.getClass());
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this._log.debug("Filtering request for {} with {}", (Object)requestContext.getUriInfo().getAbsolutePath(), (Object)this);
        try {
            if (!this._validator.validate(requestContext)) {
                requestContext.abortWith(this.errorResponse(Response.Status.UNAUTHORIZED, "You are not authorized to access this resource"));
            }
        }
        catch (BadRequestException BRe) {
            requestContext.abortWith(this.errorResponse(Response.Status.BAD_REQUEST, BRe.getMessage()));
        }
        catch (Exception e) {
            requestContext.abortWith(this.errorResponse(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }
}

