/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.server.javax.interceptors;

import java.io.IOException;
import java.security.GeneralSecurityException;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.encryption.EncryptionService;
import org.fao.fi.security.common.support.encryption.EncryptedOutputStreamWrapper;
import org.fao.fi.security.common.utilities.LoggingClient;
import org.fao.fi.security.server.javax.filters.FilterConstants;
import org.fao.fi.security.server.javax.filters.encryption.support.EncryptionConstants;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedOutputResource;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 30 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 30 Apr 2014
 */
@EncryptedOutputResource
public class EncryptedResourceWriterInterceptor extends LoggingClient implements WriterInterceptor {
	@Inject private @Singleton EncryptionService _encryptor;
	
	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.WriterInterceptor#aroundWriteTo(javax.ws.rs.ext.WriterInterceptorContext)
	 */
	@Override
	public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
		try {
			context.setOutputStream(new EncryptedOutputStreamWrapper(context.getOutputStream(), this._encryptor));
			
			context.proceed();
		} catch(IOException IOe) {
			this._log.error(IOe.getMessage(), IOe);
			
			Throwable cause = IOe.getCause();
			
			if(cause != null &&
				(KeyringException.class.isAssignableFrom(cause.getClass()) ||
				 GeneralSecurityException.class.isAssignableFrom(cause.getClass()))
			  )
				throw new WebApplicationException(Response.status(Response.Status.BAD_REQUEST).header(FilterConstants.SECURED_WITH_HEADER, EncryptionConstants.ENCRYPTED_OUTPUT_STREAM_SECURITY_TYPE_HEADER).entity("You are not authorized to access this resource").build());

			throw new WebApplicationException(Response.status(Response.Status.INTERNAL_SERVER_ERROR).header(FilterConstants.SECURED_WITH_HEADER, EncryptionConstants.ENCRYPTED_OUTPUT_STREAM_SECURITY_TYPE_HEADER).entity("You are not authorized to access this resource").build());
		}
	}
}