/**
 * (c) 2014 FAO / UN (project: fi-security-integration)
 */
package org.fao.fi.security.integration.test.support.services.secured.token.encrypted;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictedResource;
import org.fao.fi.security.server.javax.filters.token.support.EncryptedTokenSecuredResource;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 5 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 5 May 2014
 */
@Singleton @IPRestrictedResource @Path("/token/encrypted")
public class EchoServiceImplWithEncryptedToken {
	/**
	 * Class constructor
	 *
	 */
	public EchoServiceImplWithEncryptedToken() {
	}
	
	@GET
	@Path("echo/{text}")
	@Produces("text/plain")
	@EncryptedTokenSecuredResource public String echo(@PathParam(value="text") String text) throws Throwable {
		return text;
	}
}
