/**
 * (c) 2014 FAO / UN (project: fi-security-integration)
 */
package org.fao.fi.security.integration.test.support.services.secured.encryption.in;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.fao.fi.security.server.javax.filters.origin.support.IPRestrictedResource;
import org.fao.fi.security.server.javax.interceptors.support.encryption.EncryptedInputResource;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 5 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 5 May 2014
 */
@IPRestrictedResource @Path("/encryption/in")
public class EchoServiceImplWithInputEncryption {
	/**
	 * Class constructor
	 *
	 */
	public EchoServiceImplWithInputEncryption() {
	}
	
	@POST
	@Path("echo")
	@Consumes("text/plain")
	@Produces("text/plain")
	public @EncryptedInputResource Response echo(String text) throws Throwable {
		return Response.status(Status.OK).entity(text).build();
	}
}