/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath://";

    public static final String toURL(File file) throws MalformedURLException {
        String URL2 = file.toURI().toURL().toString();
        LOG.debug("Returing URL {} for file {}", (Object)URL2, (Object)file.getAbsolutePath());
        return URL2;
    }

    public static InputStream streamResource(String resourceURL) throws IOException {
        LOG.info("Streaming resource at URL {}...", (Object)resourceURL);
        if (resourceURL.startsWith(CLASSPATH_PREFIX)) {
            InputStream found = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceURL.replaceFirst(CLASSPATH_PREFIX, ""));
            if (found == null) {
                throw new FileNotFoundException("Unable to stream resource at " + resourceURL + ": resource not found");
            }
            return found;
        }
        return new URL(resourceURL).openStream();
    }

    public static InputStream streamAndCopyResource(String resourceURL) throws IOException {
        LOG.info("Streaming and copying resource at URL {}...", (Object)resourceURL);
        InputStream original = null;
        long start = System.currentTimeMillis();
        if (resourceURL.startsWith(CLASSPATH_PREFIX)) {
            LOG.info("Returning classpath resource stream for {}", (Object)resourceURL);
            original = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceURL.replaceFirst(CLASSPATH_PREFIX, ""));
            if (original == null) {
                throw new FileNotFoundException("Unable to stream resource at " + resourceURL + ": resource not found");
            }
        } else {
            LOG.info("Returning URL resource stream for {}", (Object)resourceURL);
            original = new URL(resourceURL).openStream();
        }
        long end = System.currentTimeMillis();
        LOG.info("Resource stream for {} has been opened in {} mSec.", (Object)resourceURL, (Object)(end - start));
        ByteArrayOutputStream copied = new ByteArrayOutputStream();
        LOG.info("Piping original stream into a dummy one...");
        long piped = FileUtils.pipeStreams(original, copied);
        original.close();
        copied.flush();
        copied.close();
        end = System.currentTimeMillis();
        LOG.info("{} bytes have been piped from the original stream in {} mSec.", (Object)piped, (Object)(end - start));
        return new ByteArrayInputStream(copied.toByteArray());
    }

    public static void pipeFiles(File in, File out) throws IOException {
        FileUtils.pipeStreams(new FileInputStream(in), new FileOutputStream(out));
    }

    public static long pipeStreams(InputStream in, OutputStream out) throws IOException {
        int totalLen = 0;
        int len = -1;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            totalLen += len;
        }
        out.flush();
        return totalLen;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = -1;
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }

    public static void writeBytes(byte[] in, File out) throws IOException {
        FileUtils.writeBytes(in, new FileOutputStream(out));
    }

    public static void writeBytes(byte[] in, OutputStream out) throws IOException {
        FileUtils.pipeStreams(new ByteArrayInputStream(in), out);
    }
}

