/**
 * (c) 2014 FAO / UN (project: fi-security-common)
 */
package org.fao.fi.security.common.utilities.pgp.configuration.impl.jndi;

import javax.naming.NamingException;

import org.fao.fi.security.common.support.configuration.AbstractJNDIConfiguration;
import org.fao.fi.security.common.utilities.pgp.configuration.PublicKeyringConfiguration;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 1 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 1 May 2014
 */
public class PublicKeyringJNDIConfiguration extends AbstractJNDIConfiguration implements PublicKeyringConfiguration {
	protected String _keyringResourceJNDIName;
	
	/**
	 * Class constructor
	 *
	 * @param keyringResourceJNDIName
	 */
	public PublicKeyringJNDIConfiguration(String keyringResourceJNDIName) throws NamingException {
		super();
		
		this._keyringResourceJNDIName = keyringResourceJNDIName;
	}
	
	/**
	 * @return the 'keyringResourceJNDIName' value
	 */
	public String getKeyringResourceJNDIName() {
		return this._keyringResourceJNDIName;
	}

	/* (non-Javadoc)
	 * @see org.fao.fi.security.common.pgp.configuration.KeyringConfigurator#getKeyringResource()
	 */
	@Override
	public String getKeyringResourceURL() {
		String keyringResource = this.getEnvResource(this._keyringResourceJNDIName);
			
		this._log.info("Keyring resource for {} is {}", this.getClass().getSimpleName(), keyringResource);
			
		return keyringResource;		
	}
}