/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.common.utilities.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringAccessException;
import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.utilities.FileUtils;
import org.fao.fi.security.common.utilities.pgp.AbstractPGPProcessor;

public class PGPDecryptor
extends AbstractPGPProcessor {
    public byte[] decryptBytes(byte[] encodedData, File privateKeyringFile, String passPhrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        return this.decryptBytes(encodedData, new FileInputStream(privateKeyringFile), passPhrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptBytes(byte[] encodedData, InputStream privateKeyringStream, String passPhrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        ByteArrayOutputStream decodedDataStream = null;
        try (ByteArrayInputStream encodedDataStream = null;){
            long start = System.currentTimeMillis();
            this._log.info("Decrypting {} bytes...", (Object)encodedData.length);
            encodedDataStream = new ByteArrayInputStream(encodedData);
            decodedDataStream = new ByteArrayOutputStream();
            this.doDecryptStream(encodedDataStream, decodedDataStream, privateKeyringStream, passPhrase.toCharArray());
            decodedDataStream.flush();
            decodedDataStream.close();
            long end = System.currentTimeMillis();
            this._log.info("Decrypting {} bytes took {} mSec.", (Object)(end - start));
            byte[] byArray = decodedDataStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptStream(InputStream encryptedStream, OutputStream decryptedStream, File privateKeyFile, char[] passphrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        try (FileInputStream privateKeyStream = new FileInputStream(privateKeyFile);){
            this.decryptStream(encryptedStream, decryptedStream, privateKeyStream, passphrase);
        }
    }

    public void decryptStream(InputStream encryptedStream, OutputStream decryptedStream, InputStream privateKeyStream, char[] passphrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        this.doDecryptStream(encryptedStream, decryptedStream, privateKeyStream, passphrase);
    }

    private long doDecryptStream(InputStream encryptedStream, OutputStream decryptedStream, InputStream privateKeyStream, char[] passphrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        try {
            Object message;
            block11: {
                PGPObjectFactory plainObjectFactory = new PGPObjectFactory(this.getPlainStream(encryptedStream, privateKeyStream, passphrase));
                message = null;
                try {
                    message = plainObjectFactory.nextObject();
                }
                catch (IOException IOe) {
                    if (!IOe.getMessage().contains("unknown object")) break block11;
                    throw new PGPException("Unable to decrypt stream: " + IOe.getClass().getSimpleName() + " [ " + IOe.getMessage() + " ]");
                }
            }
            if (message instanceof PGPCompressedData) {
                PGPCompressedData compressedData = (PGPCompressedData)message;
                PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(compressedData.getDataStream());
                message = pgpObjectFactory.nextObject();
            }
            if (message instanceof PGPLiteralData) {
                PGPLiteralData literalData = (PGPLiteralData)message;
                long l = FileUtils.pipeStreams(literalData.getInputStream(), decryptedStream);
                return l;
            }
            try {
                if (message instanceof PGPOnePassSignatureList) {
                    throw new PGPException("Encrypted message contains a signed message - not literal data");
                }
                throw new PGPException("Message is not a simple encrypted file - type unknown");
            }
            catch (PGPException e) {
                this._log.error("{}", (Object)(e.getUnderlyingException() != null ? e.getUnderlyingException() : e).getMessage(), (Object)e);
                throw e;
            }
        }
        finally {
            privateKeyStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getPlainStream(InputStream encryptedStream, InputStream privateKeyStream, char[] passphrase) throws IOException, KeyringException, PGPException, NoSuchProviderException {
        long start = System.currentTimeMillis();
        this._log.info("Scanning encrypted stream...");
        PGPObjectFactory objectFactory = new PGPObjectFactory(encryptedStream);
        Object object = null;
        try {
            object = objectFactory.nextObject();
        }
        catch (IOException IOe) {
            if (IOe.getMessage().contains("unknown object")) {
                throw new PGPException("Unable to decrypt stream: " + IOe.getClass().getSimpleName() + " [ " + IOe.getMessage() + " ]");
            }
            throw IOe;
        }
        if (object == null) {
            throw new PGPException("Unable to decrypt stream: NULL object returned by object factory");
        }
        PGPEncryptedDataList encryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)objectFactory.nextObject();
        Iterator publicKeyEncryptedDataIterator = encryptedDataList.getEncryptedDataObjects();
        long end = System.currentTimeMillis();
        this._log.info("Encrypted stream has been scanned in {} mSec.", (Object)(end - start));
        PGPPrivateKey privateKey = null;
        PGPPublicKeyEncryptedData publicKeyEncryptedData = null;
        while (privateKey == null && publicKeyEncryptedDataIterator.hasNext()) {
            publicKeyEncryptedData = (PGPPublicKeyEncryptedData)publicKeyEncryptedDataIterator.next();
            this._log.debug(" * Public key encrypted data key id: {}", (Object)publicKeyEncryptedData.getKeyID());
            privateKey = this.extractPrivateKey(privateKeyStream, publicKeyEncryptedData.getKeyID(), passphrase);
        }
        if (privateKey == null) {
            throw new KeyringAccessException("Unable to extract private key for message");
        }
        start = System.currentTimeMillis();
        this._log.info("Verifying data...");
        if (publicKeyEncryptedData.isIntegrityProtected()) {
            if (!publicKeyEncryptedData.verify()) {
                this._log.error("[KO] Message failed integrity check");
            } else {
                this._log.debug("[OK]  message integrity check passed");
            }
        } else {
            this._log.debug("[!!] No message integrity check");
        }
        end = System.currentTimeMillis();
        this._log.info("Data have been verified in {} mSec.", (Object)(end - start));
        start = System.currentTimeMillis();
        this._log.info("Retrieving data stream...");
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            InputStream inputStream = publicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider((Provider)provider).setContentProvider((Provider)provider).build(privateKey));
            return inputStream;
        }
        finally {
            end = System.currentTimeMillis();
            this._log.info("Data stream has been retrieved in {} mSec.", (Object)(end - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PGPPrivateKey extractPrivateKey(InputStream privateKeyStream, long keyID, char[] passphrase) throws IOException, PGPException, NoSuchProviderException {
        long start = System.currentTimeMillis();
        this._log.info("Extracting private key from private key stream (key ID: {})...", (Object)keyID);
        try {
            PGPSecretKeyRingCollection secretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)privateKeyStream));
            PGPSecretKey secretKey = secretKeyRingCollection.getSecretKey(keyID);
            if (secretKey == null) {
                PGPPrivateKey pGPPrivateKey = null;
                return pGPPrivateKey;
            }
            BouncyCastleProvider provider = new BouncyCastleProvider();
            PGPPrivateKey pGPPrivateKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider((Provider)provider).build()).setProvider((Provider)provider).build(passphrase));
            return pGPPrivateKey;
        }
        finally {
            long end = System.currentTimeMillis();
            this._log.info("Private key (key ID: {}) has been extracted from private key stream in {} mSec.", (Object)keyID, (Object)(end - start));
        }
    }
}

