/**
 * (c) 2014 FIPS / FAO of the UN (project: fi-security-common)
 */
package org.fao.fi.security.common.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 30 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 30 Apr 2014
 */
public class FileUtils {
	static final private Logger LOG = LoggerFactory.getLogger(FileUtils.class);
	
	static final private String CLASSPATH_PREFIX = "classpath://";
	
	static final public String toURL(File file) throws MalformedURLException {
		String URL = file.toURI().toURL().toString();
		
		LOG.debug("Returing URL {} for file {}", URL, file.getAbsolutePath());
		
		return URL;
	}
	static public InputStream streamResource(String resourceURL) throws IOException {
		LOG.info("Streaming resource at URL {}...", resourceURL);
		
		if(resourceURL.startsWith(CLASSPATH_PREFIX)) {
			InputStream found = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceURL.replaceFirst(CLASSPATH_PREFIX, ""));
				
			if(found == null)
				throw new FileNotFoundException("Unable to stream resource at " + resourceURL + ": resource not found");
			
			return found;
		} else {
			return new URL(resourceURL).openStream();
		}
	}
	
	static public void pipeFiles(File in, File out) throws IOException {
		FileUtils.pipeStreams(new FileInputStream(in), new FileOutputStream(out));
	}

	static public long pipeStreams(InputStream in, OutputStream out) throws IOException {
		int totalLen = 0, len = -1;
		byte[] buffer = new byte[8192];
		
		while((len = in.read(buffer)) != -1) {
			out.write(buffer, 0, len);
			totalLen += len;
		}
		
		out.flush();
		
		return totalLen;
	}

	static public byte[] readBytes(InputStream in) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		int len = -1;
		byte[] buffer = new byte[8192];
		
		while(((len = in.read(buffer)) != -1))
			baos.write(buffer, 0, len);
	
		baos.flush();
		baos.close();
	
		return baos.toByteArray();
	}

	static public void writeBytes(byte[] in, File out) throws IOException {
		FileUtils.writeBytes(in, new FileOutputStream(out));
	}

	static public void writeBytes(byte[] in, OutputStream out) throws IOException {
		FileUtils.pipeStreams(new ByteArrayInputStream(in), out);
	}
}
